/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.avm2.model;

import com.jpexs.decompiler.flash.SourceGeneratorLocalData;
import com.jpexs.decompiler.flash.abc.avm2.model.AVM2Item;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.graph.CompilationException;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.SourceGenerator;
import com.jpexs.decompiler.graph.TypeItem;
import com.jpexs.decompiler.graph.model.LocalData;
import java.util.List;

public class AlchemyStoreAVM2Item
extends AVM2Item {
    private final String type;
    private final int size;
    private final GraphTargetItem ofs;

    public AlchemyStoreAVM2Item(GraphSourceItem instruction, GraphSourceItem lineStartIns, GraphTargetItem value, GraphTargetItem ofs, String type, int size) {
        super(instruction, lineStartIns, 0, value);
        this.ofs = ofs;
        this.type = type;
        this.size = size;
    }

    @Override
    public GraphTextWriter appendTo(GraphTextWriter writer, LocalData localData) throws InterruptedException {
        writer.append("s").append(this.type).append(this.size).append("(");
        this.value.toString(writer, localData);
        writer.append(",");
        this.ofs.toString(writer, localData);
        return writer.append(")");
    }

    @Override
    public GraphTargetItem returnType() {
        return TypeItem.UNBOUNDED;
    }

    @Override
    public boolean hasReturnValue() {
        return false;
    }

    @Override
    public List<GraphSourceItem> toSource(SourceGeneratorLocalData localData, SourceGenerator generator) throws CompilationException {
        String ts = "" + this.type + this.size;
        if (this.type.equals("f4")) {
            ts = "f32x4";
        }
        int code = 0;
        switch (ts) {
            case "i8": {
                code = 58;
                break;
            }
            case "i16": {
                code = 59;
                break;
            }
            case "i32": {
                code = 60;
                break;
            }
            case "f32": {
                code = 61;
                break;
            }
            case "f32x4": {
                code = 11;
                break;
            }
            case "f64": {
                code = 62;
            }
        }
        return AlchemyStoreAVM2Item.toSourceMerge(localData, generator, this.ofs, AlchemyStoreAVM2Item.ins(code, new Integer[0]));
    }
}

