/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.avm2.model;

import com.jpexs.decompiler.flash.IdentifiersDeobfuscation;
import com.jpexs.decompiler.flash.SourceGeneratorLocalData;
import com.jpexs.decompiler.flash.abc.avm2.AVM2Code;
import com.jpexs.decompiler.flash.abc.avm2.instructions.AVM2Instruction;
import com.jpexs.decompiler.flash.abc.avm2.instructions.InstructionDefinition;
import com.jpexs.decompiler.flash.abc.avm2.model.FindPropertyAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.FullMultinameAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.LocalRegAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.parser.script.AVM2SourceGenerator;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.graph.CompilationException;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.SourceGenerator;
import com.jpexs.decompiler.graph.model.LocalData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public abstract class AVM2Item
extends GraphTargetItem {
    private AVM2Instruction instruction;
    private AVM2Instruction lineStartIns;

    public AVM2Item(GraphSourceItem instruction, GraphSourceItem lineStartIns, int precedence) {
        this(instruction, lineStartIns, precedence, null);
    }

    public AVM2Item(GraphSourceItem instruction, GraphSourceItem lineStartIns, int precedence, GraphTargetItem value) {
        super(instruction, lineStartIns, precedence, value);
        if (instruction instanceof AVM2Instruction) {
            this.instruction = (AVM2Instruction)instruction;
        }
        if (lineStartIns instanceof AVM2Instruction) {
            this.lineStartIns = (AVM2Instruction)lineStartIns;
        }
    }

    public AVM2Instruction getInstruction() {
        return this.instruction;
    }

    public AVM2Instruction getLineStartIns() {
        return this.lineStartIns;
    }

    @Override
    public boolean needsSemicolon() {
        return true;
    }

    protected GraphTextWriter formatProperty(GraphTextWriter writer, GraphTargetItem object, GraphTargetItem propertyName, LocalData localData) throws InterruptedException {
        boolean empty = object instanceof FindPropertyAVM2Item;
        if (object instanceof LocalRegAVM2Item && ((LocalRegAVM2Item)object).computedValue != null && ((LocalRegAVM2Item)object).computedValue.getThroughNotCompilable() instanceof FindPropertyAVM2Item) {
            empty = true;
        }
        if (object instanceof FindPropertyAVM2Item) {
            FindPropertyAVM2Item fp = (FindPropertyAVM2Item)object;
            if (fp.propertyName instanceof FullMultinameAVM2Item) {
                propertyName = fp.propertyName;
            }
        }
        if (!empty && object != null) {
            if (object.getPrecedence() > 0) {
                writer.append("(");
                object.toString(writer, localData);
                writer.append(")");
                empty = false;
            } else {
                int writerLength = writer.getLength();
                object.toString(writer, localData);
                if (writerLength == writer.getLength()) {
                    empty = true;
                }
            }
        }
        if (empty) {
            return propertyName.toString(writer, localData);
        }
        if (propertyName instanceof FullMultinameAVM2Item) {
            if (((FullMultinameAVM2Item)propertyName).name != null) {
                if (((FullMultinameAVM2Item)propertyName).namespace != null) {
                    writer.append(".");
                }
                return propertyName.toString(writer, localData);
            }
            writer.append(".");
            return propertyName.toString(writer, localData);
        }
        writer.append("[");
        propertyName.toString(writer, localData);
        return writer.append("]");
    }

    public static String localRegName(HashMap<Integer, String> localRegNames, int reg) {
        if (localRegNames.containsKey(reg)) {
            return IdentifiersDeobfuscation.printIdentifier(true, localRegNames.get(reg), new String[0]);
        }
        if (reg == 0) {
            return "this";
        }
        return String.format(Configuration.registerNameFormat.get(), reg);
    }

    @Override
    public List<GraphSourceItem> toSourceIgnoreReturnValue(SourceGeneratorLocalData localData, SourceGenerator generator) throws CompilationException {
        if (!this.hasReturnValue()) {
            return this.toSource(localData, generator);
        }
        List<GraphSourceItem> ret = this.toSource(localData, generator);
        ret.add(new AVM2Instruction(0L, 41, null));
        return ret;
    }

    public static AVM2Instruction ins(int instructionCode, Integer ... operands) {
        InstructionDefinition def = AVM2Code.instructionSet[instructionCode];
        ArrayList<Integer> ops = new ArrayList<Integer>();
        for (Integer o : operands) {
            if (o == null) continue;
            ops.add(o);
        }
        int[] opArr = new int[ops.size()];
        for (int i = 0; i < ops.size(); ++i) {
            opArr[i] = (Integer)ops.get(i);
        }
        return new AVM2Instruction(0L, def, opArr);
    }

    public static int getFreeRegister(SourceGeneratorLocalData localData, SourceGenerator generator) {
        AVM2SourceGenerator g = (AVM2SourceGenerator)generator;
        return g.getFreeRegister(localData);
    }

    public static void killRegister(SourceGeneratorLocalData localData, SourceGenerator generator, int regNumber) {
        AVM2SourceGenerator g = (AVM2SourceGenerator)generator;
        g.killRegister(localData, regNumber);
    }
}

