/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash;

import com.jpexs.decompiler.flash.BinarySWFBundle;
import com.jpexs.decompiler.flash.SWC;
import com.jpexs.decompiler.flash.SWFBundle;
import com.jpexs.decompiler.flash.SearchMode;
import com.jpexs.decompiler.flash.ZippedSWFBundle;
import com.jpexs.decompiler.flash.iggy.conversion.IggySwfBundle;
import com.jpexs.helpers.Path;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class SWFSourceInfo {
    private final InputStream inputStream;
    private String file;
    private final String fileTitle;

    public SWFSourceInfo(InputStream inputStream, String file, String fileTitle) {
        this.inputStream = inputStream;
        this.file = file;
        this.fileTitle = fileTitle;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public String getFileTitle() {
        return this.fileTitle;
    }

    public String getFileTitleOrName() {
        if (this.fileTitle != null) {
            return this.fileTitle;
        }
        return this.file;
    }

    public boolean isBundle() {
        if (this.inputStream == null) {
            File fileObj = new File(this.file);
            String fileName = fileObj.getName();
            if (fileName.startsWith("asdec_") && fileName.endsWith(".tmp")) {
                return false;
            }
            String extension = Path.getExtension(fileObj);
            return extension == null || !extension.equals(".swf") && !extension.equals(".gfx");
        }
        return false;
    }

    public SWFBundle getBundle(boolean noCheck, SearchMode searchMode) throws IOException {
        if (!this.isBundle()) {
            return null;
        }
        String extension = Path.getExtension(new File(this.file));
        if (extension != null) {
            switch (extension) {
                case ".swc": {
                    return new SWC(new File(this.file));
                }
                case ".zip": {
                    return new ZippedSWFBundle(new File(this.file));
                }
                case ".iggy": {
                    return new IggySwfBundle(new File(this.file));
                }
            }
        }
        return new BinarySWFBundle(new BufferedInputStream(new FileInputStream(this.file)), noCheck, searchMode);
    }
}

