/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.debugger.flash;

import com.jpexs.debugger.flash.DebuggerConnection;
import com.jpexs.debugger.flash.DebuggerMessage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class OutDebuggerMessage
extends DebuggerMessage {
    public static int ID;
    protected int type;
    public static final int DEFAULT_ISOLATE_ID = 1;
    public int targetIsolate;
    private ByteArrayOutputStream os;
    protected DebuggerConnection connection;
    protected static boolean supportsWideLineNumbers;

    public OutDebuggerMessage(DebuggerConnection c, int type, byte[] data) {
        this.type = type;
        this.connection = c;
        this.targetIsolate = c.activeIsolateId;
        this.os = new ByteArrayOutputStream();
        if (data.length > 0) {
            try {
                this.os.write(data);
            }
            catch (IOException ex) {
                Logger.getLogger(OutDebuggerMessage.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    @Override
    public byte[] getData() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            this.writeTo(baos);
        }
        catch (IOException ex) {
            Logger.getLogger(OutDebuggerMessage.class.getName()).log(Level.SEVERE, null, ex);
        }
        return baos.toByteArray();
    }

    public void writeTo(OutputStream os) throws IOException {
    }

    public OutDebuggerMessage(DebuggerConnection c, int type) {
        this(c, type, new byte[0]);
    }

    public void writeDWord(OutputStream os, long val) throws IOException {
        int b1 = (int)(val & 0xFFL);
        int b2 = (int)(val >> 8 & 0xFFL);
        int b3 = (int)(val >> 16 & 0xFFL);
        int b4 = (int)(val >> 24 & 0xFFL);
        os.write(b1);
        os.write(b2);
        os.write(b3);
        os.write(b4);
    }

    public void writeLong(OutputStream os, long val) throws IOException {
        this.writeDWord(os, val & 0xFFFFFFFFFFFFFFFFL);
        this.writeDWord(os, val >> 32 & 0xFFFFFFFFFFFFFFFFL);
    }

    public void writeByte(OutputStream os, int val) throws IOException {
        os.write(val & 0xFF);
    }

    public void writeBytes(OutputStream os, byte[] data) {
        try {
            os.write(data);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void writeWord(OutputStream os, long val) throws IOException {
        int b1 = (int)(val & 0xFFL);
        int b2 = (int)(val >> 8 & 0xFFL);
        os.write(b1);
        os.write(b2);
    }

    public void writeString(OutputStream os, String val) throws IOException {
        try {
            os.write(val.getBytes("UTF-8"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        os.write(0);
    }

    @Override
    public int getType() {
        return this.type;
    }

    public void writePtr(OutputStream os, long ptr) throws IOException {
        if (this.connection.sizeOfPtr == 4) {
            this.writeDWord(os, ptr);
        } else if (this.connection.sizeOfPtr == 8) {
            this.writeLong(os, ptr);
        }
    }

    static {
        supportsWideLineNumbers = true;
    }
}

