/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.sfntly.data;

import com.google.typography.font.sfntly.data.ByteArray;
import com.google.typography.font.sfntly.data.GrowableMemoryByteArray;
import com.google.typography.font.sfntly.data.MemoryByteArray;
import com.google.typography.font.sfntly.data.ReadableFontData;
import java.io.IOException;
import java.io.InputStream;

public final class WritableFontData
extends ReadableFontData {
    public static final WritableFontData createWritableFontData(int n) {
        ByteArray byteArray = null;
        if (n > 0) {
            byteArray = new MemoryByteArray(n);
            byteArray.setFilledLength(n);
        } else {
            byteArray = new GrowableMemoryByteArray();
        }
        WritableFontData writableFontData = new WritableFontData(byteArray);
        return writableFontData;
    }

    public static final WritableFontData createWritableFontData(byte[] byArray) {
        MemoryByteArray memoryByteArray = new MemoryByteArray(byArray);
        WritableFontData writableFontData = new WritableFontData(memoryByteArray);
        return writableFontData;
    }

    public static final WritableFontData createWritableFontData(ReadableFontData readableFontData) {
        ByteArray byteArray = null;
        byteArray = readableFontData.array.growable() ? new GrowableMemoryByteArray() : new MemoryByteArray(readableFontData.array.length());
        readableFontData.array.copyTo(byteArray);
        WritableFontData writableFontData = new WritableFontData(byteArray);
        writableFontData.setCheckSumRanges(readableFontData.checkSumRange());
        return writableFontData;
    }

    private WritableFontData(ByteArray<? extends ByteArray<?>> byteArray) {
        super(byteArray);
    }

    private WritableFontData(WritableFontData writableFontData, int n) {
        super(writableFontData, n);
    }

    private WritableFontData(WritableFontData writableFontData, int n, int n2) {
        super(writableFontData, n, n2);
    }

    @Override
    public WritableFontData slice(int n, int n2) {
        if (n < 0 || n + n2 > this.size()) {
            throw new IndexOutOfBoundsException("Attempt to bind data outside of its limits.");
        }
        WritableFontData writableFontData = new WritableFontData(this, n, n2);
        return writableFontData;
    }

    @Override
    public WritableFontData slice(int n) {
        if (n < 0 || n > this.size()) {
            throw new IndexOutOfBoundsException("Attempt to bind data outside of its limits.");
        }
        WritableFontData writableFontData = new WritableFontData(this, n);
        return writableFontData;
    }

    public int writeByte(int n, byte by) {
        this.array.put(this.boundOffset(n), by);
        return 1;
    }

    public int writeBytes(int n, byte[] byArray, int n2, int n3) {
        return this.array.put(this.boundOffset(n), byArray, n2, this.boundLength(n, n3));
    }

    public int writeBytesPad(int n, byte[] byArray, int n2, int n3, byte by) {
        int n4 = this.array.put(this.boundOffset(n), byArray, n2, this.boundLength(n, Math.min(n3, byArray.length - n2)));
        n4 += this.writePadding(n4 + n, n3 - n4, by);
        return n4;
    }

    public int writePadding(int n, int n2) {
        return this.writePadding(n, n2, (byte)0);
    }

    public int writePadding(int n, int n2, byte by) {
        for (int i = 0; i < n2; ++i) {
            this.array.put(n + i, by);
        }
        return n2;
    }

    public int writeBytes(int n, byte[] byArray) {
        return this.writeBytes(n, byArray, 0, byArray.length);
    }

    public int writeChar(int n, byte by) {
        return this.writeByte(n, by);
    }

    public int writeUShort(int n, int n2) {
        this.writeByte(n, (byte)(n2 >> 8 & 0xFF));
        this.writeByte(n + 1, (byte)(n2 & 0xFF));
        return 2;
    }

    public int writeUShortLE(int n, int n2) {
        this.array.put(n, (byte)(n2 & 0xFF));
        this.array.put(n + 1, (byte)(n2 >> 8 & 0xFF));
        return 2;
    }

    public int writeShort(int n, int n2) {
        return this.writeUShort(n, n2);
    }

    public int writeUInt24(int n, int n2) {
        this.writeByte(n, (byte)(n2 >> 16 & 0xFF));
        this.writeByte(n + 1, (byte)(n2 >> 8 & 0xFF));
        this.writeByte(n + 2, (byte)(n2 & 0xFF));
        return 3;
    }

    public int writeULong(int n, long l) {
        this.writeByte(n, (byte)(l >> 24 & 0xFFL));
        this.writeByte(n + 1, (byte)(l >> 16 & 0xFFL));
        this.writeByte(n + 2, (byte)(l >> 8 & 0xFFL));
        this.writeByte(n + 3, (byte)(l & 0xFFL));
        return 4;
    }

    public int writeULongLE(int n, long l) {
        this.array.put(n, (byte)(l & 0xFFL));
        this.array.put(n + 1, (byte)(l >> 8 & 0xFFL));
        this.array.put(n + 2, (byte)(l >> 16 & 0xFFL));
        this.array.put(n + 3, (byte)(l >> 24 & 0xFFL));
        return 4;
    }

    public int writeLong(int n, long l) {
        return this.writeULong(n, l);
    }

    public int writeFixed(int n, int n2) {
        return this.writeLong(n, n2);
    }

    public int writeDateTime(int n, long l) {
        this.writeULong(n, l >> 32 & 0xFFFFFFFFFFFFFFFFL);
        this.writeULong(n + 4, l & 0xFFFFFFFFFFFFFFFFL);
        return 8;
    }

    public void copyFrom(InputStream inputStream, int n) throws IOException {
        this.array.copyFrom(inputStream, n);
    }

    public void copyFrom(InputStream inputStream) throws IOException {
        this.array.copyFrom(inputStream);
    }
}

