# Contributing

First off, thank you for considering contributing to USB Canary. 

### 1. Where do I go from here?

If you've noticed a bug or have a question [search the issue tracker](https://github.com/probablynotablog/usb-canary/issues)
to see if someone else in the community has already created a ticket. If not, go ahead and [make one](https://github.com/probablynotablog/usb-canary/issues/new)!

### 2. Fork & create a branch

If this is something you think you can fix, then [fork USB Canary](https://help.github.com/articles/fork-a-repo)
and create a branch with a descriptive name.

A good branch name would be (where issue #325 is the ticket you're working on):

```sh
git checkout -b 325-add-windows-support
```

#### 3. Did you find a bug?

* **Ensure the bug was not already reported** by searching on GitHub under [Issues](https://github.com/probablynotablog/usb-canary/issues).

* If you're unable to find an open issue addressing the problem, [open a new one](https://github.com/probablynotablog/usb-canary/issues/new). 
Be sure to include a **title and clear description**, as much relevant information as possible - use the relevant bug report templates to create the issue. 

### 4. Implement your fix or feature

At this point, you're ready to make your changes! Feel free to ask for help; everyone is a beginner at first.

### 5. Test your changes

We don't currently have an automated test suite, so it's up to you to test your bug fix or feature to ensure it does not impact existing features, unless that feature was really a bug and you're fixing it. If you're unable to test your new feature, reach out to one of the maintainers who will be happy to help. (It may take longer to be accepted)

### 6. Make a Pull Request

At this point, you should switch back to your master branch and make sure it's
up to date with USB Canary's master branch.

Push it!

Finally, go to GitHub and [make a Pull Request](https://help.github.com/articles/creating-a-pull-request).
