#!/usr/bin/python
'''
//=============================================================================
//
//  File : ufo_mactoolsgui.py
//  Creation date : Wed Dec 05 14:30:48 CEST 2012
//  Working on this file:   asterix (Cristian Steri)
//                          Grifisx (Antonino G. Imbesi)
//   This file is part of the Ufo Wardriving distribution
//
//  Websites: http://ufo-wardriving.com
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//  This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
//
//=============================================================================
'''

import os
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from PyQt4.QtWebKit import *

import sys, os.path
import subprocess
import re
import platform

from core.ufo_picsfinder import get_icon
from core.ufo_finddir import find_dir
from core.ufo_linuxscanner import *
from core.ufo_mactools import *

from ui import ufo_scanelement
from core import ufo_windows_scanner

class UFOMacChanger(QWidget):
    def __init__(self, parent=None):
        super(UFOMacChanger, self).__init__(parent)
        self.setMaximumHeight(300)
        self.setMaximumWidth(300)
        self.setWindowTitle(_("Mac changer"))
        self.setWindowIcon(get_icon("about.png"))
        upHBoxLayout = QHBoxLayout()
        upHBoxLayout.setSpacing(5)
        downHBoxLayout = QHBoxLayout()
        downHBoxLayout.setSpacing(5)
        ddHBoxLayout = QHBoxLayout()
        ddHBoxLayout.setSpacing(5)
        vBoxLayout = QVBoxLayout(self)
        vBoxLayout.setSpacing(5)
        self.macLineEdit = QLineEdit(self)
        self.macLineEdit.setInputMask("HH:HH:HH:HH:HH:HH;_")
        self.macLabel = QLabel(self)
        self.ifaceComboBox= QComboBox(self)
        self.actualCBIdx = 0
        if platform.system() == "Windows":
            l = ufo_windows_scanner.get_interfaces_list()
        else:
            l = get_iface_list()
        idx = 1
        for i in l:
            if i !="":
                self.ifaceComboBox.addItem(get_icon("iface.png"),i)
                idx = idx+1
        if platform.system() == "Windows":
            pass
        else:
            self.macLabel.setText("<i>"+get_mac_unix(self.ifaceComboBox.itemText(0))+"</i>")
   
        self.changePushButton = QPushButton(_("Change"),self)
        self.changePushButton.setEnabled(0)
        self.randomPushButton = QPushButton(_("Random"),self)
        self.funnyPushButton = QPushButton(_("Funny"),self)
        vBoxLayout.addLayout(upHBoxLayout)
        vBoxLayout.addLayout(downHBoxLayout)
        vBoxLayout.addLayout(ddHBoxLayout)
        upHBoxLayout.addWidget(self.ifaceComboBox)
        upHBoxLayout.addWidget(self.macLabel)
        downHBoxLayout.addWidget(self.macLineEdit)
        downHBoxLayout.addWidget(self.changePushButton)
        ddHBoxLayout.addWidget(self.funnyPushButton)
        ddHBoxLayout.addWidget(self.randomPushButton)
        self.macLineEdit.textChanged.connect(self.enableMacChangeButton)
        self.ifaceComboBox.activated.connect(self.slotUpdateMac)
        self.changePushButton.clicked.connect(self.slotChangeMac)
        self.randomPushButton.clicked.connect(self.slotRandomMac)
        self.funnyPushButton.clicked.connect(self.slotFunnyMac)
        
    def enableMacChangeButton(self):
        if self.macLineEdit.text().length()==17:
            self.changePushButton.setEnabled(1)
        else:
            self.changePushButton.setEnabled(0)


    def slotRandomMac(self):

        if platform.system() == "Windows":
            admin_or_not = mac_random(self.ifaceComboBox.currentText())
            QApplication.processEvents()
            if admin_or_not:
                self.macLabel.setText(_("<i>Random MAC was set</i>"))
            else:
                self.macLabel.setText("")
        else:
            mac_random(self.ifaceComboBox.currentText())
            QApplication.processEvents()
            self.macLabel.setText("<i>"+get_mac_unix(self.ifaceComboBox.itemText(self.actualCBIdx))+"</i>")

        
    def slotFunnyMac(self):
        if platform.system() == "Windows":
            admin_or_not = mac_funny(self.ifaceComboBox.currentText())
            QApplication.processEvents()
            if admin_or_not:
                self.macLabel.setText(_("<i>Funny MAC was set</i>"))
            else:
                self.macLabel.setText("")
        else:
            mac_funny(self.ifaceComboBox.currentText())
            QApplication.processEvents()
            self.macLabel.setText("<i>"+get_mac_unix(self.ifaceComboBox.itemText(self.actualCBIdx))+"</i>")


    def slotUpdateMac(self,i):
        if platform.system() == "Windows":
            self.macLabel.setText("")
        else:
            self.macLabel.setText("<i>"+get_mac_unix(self.ifaceComboBox.itemText(i))+"</i>")
        self.actualCBIdx = i

        
    def slotChangeMac(self):
        if platform.system() == "Windows":
            admin_or_not = mac_change(self.ifaceComboBox.currentText(),self.macLineEdit.text().replace(":",""))
            QApplication.processEvents()
            if admin_or_not:
                self.macLabel.setText(_("<i>New MAC was set</i>"))
            else:
                self.macLabel.setText("")
        else:
            mac_change(self.ifaceComboBox.currentText(),self.macLineEdit.text())
            QApplication.processEvents()
            self.macLabel.setText("<i>"+get_mac_unix(self.ifaceComboBox.itemText(self.actualCBIdx))+"</i>")

    def keyPressEvent(self, event): #QKeyEvent
        if event.key() == Qt.Key_F3:
            self.setVisible(0)
        # pass the event up the chain or we will eat the event
        QWidget.keyPressEvent(self, event)
