/************************************************************************************
*
*  (C) COPYRIGHT AUTHORS, 2017 - 2023, translated from Microsoft sources/debugger
*
*  TITLE:       NTSXS.H
*
*  VERSION:     1.05
*
*  DATE:        24 Jun 2023
*
*  Common header file for the SxS related API functions and definitions.
*
* THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF
* ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED
* TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A
* PARTICULAR PURPOSE.
*
************************************************************************************/

#ifndef NTSXS_RTL
#define NTSXS_RTL

//
// NTSXS_RTL HEADER BEGIN
//

#if defined(__cplusplus)
extern "C" {
#endif

#pragma warning(push)
#pragma warning(disable: 4214) // nonstandard extension used : bit field types other than int

#define ACTCTX_PROCESS_DEFAULT ((void*)NULL)
#define ACTCTX_EMPTY ((void*)(LONG_PTR)-3)
#define ACTCTX_SYSTEM_DEFAULT  ((void*)(LONG_PTR)-4)
#define IS_SPECIAL_ACTCTX(x) (((((LONG_PTR)(x)) - 1) | 7) == -1)

typedef struct _ACTIVATION_CONTEXT *PACTIVATION_CONTEXT;
typedef const struct _ACTIVATION_CONTEXT *PCACTIVATION_CONTEXT;

#define INVALID_ACTIVATION_CONTEXT ((PACTIVATION_CONTEXT) ((LONG_PTR) -1))

#define RTL_QUERY_INFORMATION_ACTIVATION_CONTEXT_FLAG_USE_ACTIVE_ACTIVATION_CONTEXT (0x00000001)
#define RTL_QUERY_INFORMATION_ACTIVATION_CONTEXT_FLAG_ACTIVATION_CONTEXT_IS_MODULE  (0x00000002)
#define RTL_QUERY_INFORMATION_ACTIVATION_CONTEXT_FLAG_ACTIVATION_CONTEXT_IS_ADDRESS (0x00000004)
#define RTL_QUERY_INFORMATION_ACTIVATION_CONTEXT_FLAG_NO_ADDREF  (0x80000000)

#define FIND_ACTIVATION_CONTEXT_SECTION_KEY_RETURN_ACTIVATION_CONTEXT (0x00000001)
#define FIND_ACTIVATION_CONTEXT_SECTION_KEY_RETURN_FLAGS              (0x00000002)
#define FIND_ACTIVATION_CONTEXT_SECTION_KEY_RETURN_ASSEMBLY_METADATA  (0x00000004)

#define ACTIVATION_CONTEXT_SECTION_FORMAT_UNKNOWN  0
#define ACTIVATION_CONTEXT_SECTION_FORMAT_STRING   1
#define ACTIVATION_CONTEXT_SECTION_FORMAT_GUID     2

#define ACTIVATION_CONTEXT_DATA_MAGIC               0x78746341 //'xtcA'
#define ACTIVATION_CONTEXT_STRING_SECTION_MAGIC     0x64487353 //'dHsS'
#define ACTIVATION_CONTEXT_GUID_SECTION_MAGIC       0x64487347 //'dHsG'

typedef struct _ACTIVATION_CONTEXT_DATA_TOC_HEADER {
    ULONG HeaderSize;
    ULONG EntryCount;
    ULONG FirstEntryOffset;
    ULONG Flags;
} ACTIVATION_CONTEXT_DATA_TOC_HEADER, *PACTIVATION_CONTEXT_DATA_TOC_HEADER;

typedef struct _ACTIVATION_CONTEXT_DATA_EXTENDED_TOC_HEADER {
    ULONG HeaderSize;
    ULONG EntryCount;
    ULONG FirstEntryOffset;
    ULONG Flags;
} ACTIVATION_CONTEXT_DATA_EXTENDED_TOC_HEADER, *PACTIVATION_CONTEXT_DATA_EXTENDED_TOC_HEADER;

typedef struct _ACTIVATION_CONTEXT_DATA_TOC_ENTRY {
    ULONG Id;  //type of section
    ULONG Offset;
    ULONG Length;
    ULONG Format; //ACTIVATION_CONTEXT_SECTION_FORMAT_*
} ACTIVATION_CONTEXT_DATA_TOC_ENTRY, *PACTIVATION_CONTEXT_DATA_TOC_ENTRY;

typedef struct _ACTIVATION_CONTEXT_DATA_EXTENDED_TOC_ENTRY {
    GUID ExtensionGuid;
    ULONG Offset;
    ULONG Length;
} ACTIVATION_CONTEXT_DATA_EXTENDED_TOC_ENTRY, *PACTIVATION_CONTEXT_DATA_EXTENDED_TOC_ENTRY;

typedef struct _ACTIVATION_CONTEXT_STRING_SECTION_HEADER {
    ULONG Magic;
    ULONG HeaderSize;
    ULONG FormatVersion;
    ULONG DataFormatVersion;
    ULONG Flags;
    ULONG ElementCount;
    ULONG ElementListOffset;
    ULONG HashAlgorithm;
    ULONG SearchStructureOffset;
    ULONG UserDataOffset;
    ULONG UserDataSize;
} ACTIVATION_CONTEXT_STRING_SECTION_HEADER, *PACTIVATION_CONTEXT_STRING_SECTION_HEADER;

#define ACTIVATION_CONTEXT_STRING_SECTION_CASE_INSENSITIVE              (0x00000001)
#define ACTIVATION_CONTEXT_STRING_SECTION_ENTRIES_IN_PSEUDOKEY_ORDER    (0x00000002)

typedef struct _ACTIVATION_CONTEXT_STRING_SECTION_HASH_TABLE {
    ULONG BucketTableEntryCount;
    ULONG BucketTableOffset;
} ACTIVATION_CONTEXT_STRING_SECTION_HASH_TABLE, *PACTIVATION_CONTEXT_STRING_SECTION_HASH_TABLE;

typedef struct _ACTIVATION_CONTEXT_STRING_SECTION_HASH_BUCKET {
    ULONG ChainCount;
    ULONG ChainOffset;
} ACTIVATION_CONTEXT_STRING_SECTION_HASH_BUCKET, *PACTIVATION_CONTEXT_STRING_SECTION_HASH_BUCKET;

typedef struct _ACTIVATION_CONTEXT_STRING_SECTION_ENTRY {
    ULONG PseudoKey;
    ULONG KeyOffset;
    ULONG KeyLength;
    ULONG Offset;
    ULONG Length;
    ULONG AssemblyRosterIndex;
} ACTIVATION_CONTEXT_STRING_SECTION_ENTRY, *PACTIVATION_CONTEXT_STRING_SECTION_ENTRY;

typedef struct _ACTIVATION_CONTEXT_GUID_SECTION_HEADER {
    ULONG Magic;
    ULONG HeaderSize;
    ULONG FormatVersion;
    ULONG DataFormatVersion;
    ULONG Flags;
    ULONG ElementCount;
    ULONG ElementListOffset;
    ULONG HashAlgorithm;
    ULONG SearchStructureOffset;
    ULONG UserDataOffset;
    ULONG UserDataSize;
} ACTIVATION_CONTEXT_GUID_SECTION_HEADER, PACTIVATION_CONTEXT_GUID_SECTION_HEADER;

typedef struct _ACTIVATION_CONTEXT_GUID_SECTION_HASH_TABLE {
    ULONG BucketTableEntryCount;
    ULONG BucketTableOffset;
} ACTIVATION_CONTEXT_GUID_SECTION_HASH_TABLE, *PACTIVATION_CONTEXT_GUID_SECTION_HASH_TABLE;

typedef struct _ACTIVATION_CONTEXT_GUID_SECTION_HASH_BUCKET {
    ULONG ChainCount;
    ULONG ChainOffset;
} ACTIVATION_CONTEXT_GUID_SECTION_HASH_BUCKET, *PACTIVATION_CONTEXT_GUID_SECTION_HASH_BUCKET;

typedef struct _ACTIVATION_CONTEXT_GUID_SECTION_ENTRY {
    GUID Guid;
    ULONG Offset;
    ULONG Length;
    ULONG AssemblyRosterIndex;
} ACTIVATION_CONTEXT_GUID_SECTION_ENTRY, *PACTIVATION_CONTEXT_GUID_SECTION_ENTRY;

typedef struct _ACTIVATION_CONTEXT_DATA_ASSEMBLY_GLOBAL_INFORMATION {
    ULONG Size;
    ULONG Flags;
    GUID PolicyCoherencyGuid;
    GUID PolicyOverrideGuid;
    ULONG ApplicationDirectoryPathType;
    ULONG ApplicationDirectoryLength;
    ULONG ApplicationDirectoryOffset;
    ULONG ResourceName;
} ACTIVATION_CONTEXT_DATA_ASSEMBLY_GLOBAL_INFORMATION, *PACTIVATION_CONTEXT_DATA_ASSEMBLY_GLOBAL_INFORMATION;

#define ACTIVATION_CONTEXT_DATA_ASSEMBLY_INFORMATION_ROOT_ASSEMBLY              (0x00000001)
#define ACTIVATION_CONTEXT_DATA_ASSEMBLY_INFORMATION_POLICY_APPLIED             (0x00000002)
#define ACTIVATION_CONTEXT_DATA_ASSEMBLY_INFORMATION_ASSEMBLY_POLICY_APPLIED    (0x00000004)
#define ACTIVATION_CONTEXT_DATA_ASSEMBLY_INFORMATION_ROOT_POLICY_APPLIED        (0x00000008)
#define ACTIVATION_CONTEXT_DATA_ASSEMBLY_INFORMATION_PRIVATE_ASSEMBLY           (0x00000010)

#pragma pack(push,1)
typedef struct _ACTIVATION_CONTEXT_DATA_ASSEMBLY_INFORMATION {
    ULONG Size;
    ULONG Flags;
    ULONG EncodedAssemblyIdentityLength;
    ULONG EncodedAssemblyIdentityOffset;
    ULONG ManifestPathType;
    ULONG ManifestPathLength;
    ULONG ManifestPathOffset;
    LARGE_INTEGER ManifestLastWriteTime;
    ULONG PolicyPathType;
    ULONG PolicyPathLength;
    ULONG PolicyPathOffset;
    LARGE_INTEGER PolicyLastWriteTime;
    ULONG MetadataSatelliteRosterIndex;
    ULONG Unused2;
    ULONG ManifestVersionMajor;
    ULONG ManifestVersionMinor;
    ULONG PolicyVersionMajor;
    ULONG PolicyVersionMinor;
    ULONG AssemblyDirectoryNameLength;
    ULONG AssemblyDirectoryNameOffset;
    ULONG NumOfFilesInAssembly;
    ULONG LanguageLength;
    ULONG LanguageOffset;
    ACTCTX_REQUESTED_RUN_LEVEL RunLevel;
    ULONG UiAccess;
} ACTIVATION_CONTEXT_DATA_ASSEMBLY_INFORMATION, *PACTIVATION_CONTEXT_DATA_ASSEMBLY_INFORMATION;
#pragma pack(pop)

#define ACTIVATION_CONTEXT_DATA_DLL_REDIRECTION_PATH_INCLUDES_BASE_NAME                     (0x00000001)
#define ACTIVATION_CONTEXT_DATA_DLL_REDIRECTION_PATH_OMITS_ASSEMBLY_ROOT                    (0x00000002)
#define ACTIVATION_CONTEXT_DATA_DLL_REDIRECTION_PATH_EXPAND                                 (0x00000004)
#define ACTIVATION_CONTEXT_DATA_DLL_REDIRECTION_PATH_SYSTEM_DEFAULT_REDIRECTED_SYSTEM32_DLL (0x00000008)

typedef struct _ACTIVATION_CONTEXT_DATA_DLL_REDIRECTION {
    ULONG Size;
    ULONG Flags;
    ULONG TotalPathLength;
    ULONG PathSegmentCount;
    ULONG PathSegmentOffset;
} ACTIVATION_CONTEXT_DATA_DLL_REDIRECTION, *PACTIVATION_CONTEXT_DATA_DLL_REDIRECTION;

typedef struct _ACTIVATION_CONTEXT_DATA_DLL_REDIRECTION_PATH_SEGMENT {
    ULONG Length;
    ULONG Offset;
} ACTIVATION_CONTEXT_DATA_DLL_REDIRECTION_PATH_SEGMENT, *PACTIVATION_CONTEXT_DATA_DLL_REDIRECTION_PATH_SEGMENT;

typedef struct _ACTIVATION_CONTEXT_DATA_WINDOW_CLASS_REDIRECTION {
    ULONG Size;
    ULONG Flags;
    ULONG VersionSpecificClassNameLength;
    ULONG VersionSpecificClassNameOffset;
    ULONG DllNameLength;
    ULONG DllNameOffset;
} ACTIVATION_CONTEXT_DATA_WINDOW_CLASS_REDIRECTION, *PACTIVATION_CONTEXT_DATA_WINDOW_CLASS_REDIRECTION;

#define ACTIVATION_CONTEXT_DATA_APPLICATION_SETTINGS_FORMAT_LONGHORN (1)

#define SXS_WINDOWS_SETTINGS_NAMESPACE          L"http://schemas.microsoft.com/SMI/2005/WindowsSettings"
#define SXS_WINDOWS_SETTINGS_NAMESPACE_CCH      (53)

#define SXS_WINDOWS_SETTINGS_2011_NAMESPACE     L"http://schemas.microsoft.com/SMI/2011/WindowsSettings"
#define SXS_WINDOWS_SETTINGS_2011_NAMESPACE_CCH (53)

#define SXS_WINDOWS_SETTINGS_2013_NAMESPACE     L"http://schemas.microsoft.com/SMI/2013/WindowsSettings"
#define SXS_WINDOWS_SETTINGS_2013_NAMESPACE_CCH (53)

#define SXS_WINDOWS_SETTINGS_2014_NAMESPACE     L"http://schemas.microsoft.com/SMI/2014/WindowsSettings"
#define SXS_WINDOWS_SETTINGS_2014_NAMESPACE_CCH (53)

#define SXS_WINDOWS_SETTINGS_2016_NAMESPACE     L"http://schemas.microsoft.com/SMI/2016/WindowsSettings"
#define SXS_WINDOWS_SETTINGS_2016_NAMESPACE_CCH (53)

#define SXS_WINDOWS_SETTINGS_2017_NAMESPACE     L"http://schemas.microsoft.com/SMI/2017/WindowsSettings"
#define SXS_WINDOWS_SETTINGS_2017_NAMESPACE_CCH (53)

typedef struct _ACTIVATION_CONTEXT_DATA_APPLICATION_SETTINGS {
    ULONG Size;
    ULONG Flags;
    ULONG SettingNamespaceLength;
    ULONG SettingNamespaceOffset;
    ULONG SettingNameLength;
    ULONG SettingNameOffset;
    ULONG SettingValueLength;
    ULONG SettingValueOffset;
} ACTIVATION_CONTEXT_DATA_APPLICATION_SETTINGS, *PACTIVATION_CONTEXT_DATA_APPLICATION_SETTINGS;

#define ACTIVATION_CONTEXT_DATA_COM_SERVER_REDIRECTION_FORMAT_WHISTLER (1)

#define ACTIVATION_CONTEXT_DATA_COM_SERVER_REDIRECTION_THREADING_MODEL_INVALID (0)
#define ACTIVATION_CONTEXT_DATA_COM_SERVER_REDIRECTION_THREADING_MODEL_APARTMENT (1)
#define ACTIVATION_CONTEXT_DATA_COM_SERVER_REDIRECTION_THREADING_MODEL_FREE (2)
#define ACTIVATION_CONTEXT_DATA_COM_SERVER_REDIRECTION_THREADING_MODEL_SINGLE (3)
#define ACTIVATION_CONTEXT_DATA_COM_SERVER_REDIRECTION_THREADING_MODEL_BOTH (4)
#define ACTIVATION_CONTEXT_DATA_COM_SERVER_REDIRECTION_THREADING_MODEL_NEUTRAL (5)

#define ACTIVATION_CONTEXT_DATA_COM_SERVER_MISCSTATUS_FLAG_OFFSET       (8)
#define ACTIVATION_CONTEXT_DATA_COM_SERVER_MISCSTATUS_HAS_DEFAULT       (0x01 << ACTIVATION_CONTEXT_DATA_COM_SERVER_MISCSTATUS_FLAG_OFFSET)
#define ACTIVATION_CONTEXT_DATA_COM_SERVER_MISCSTATUS_HAS_ICON          (0x02 << ACTIVATION_CONTEXT_DATA_COM_SERVER_MISCSTATUS_FLAG_OFFSET)
#define ACTIVATION_CONTEXT_DATA_COM_SERVER_MISCSTATUS_HAS_CONTENT       (0x04 << ACTIVATION_CONTEXT_DATA_COM_SERVER_MISCSTATUS_FLAG_OFFSET)
#define ACTIVATION_CONTEXT_DATA_COM_SERVER_MISCSTATUS_HAS_THUMBNAIL     (0x08 << ACTIVATION_CONTEXT_DATA_COM_SERVER_MISCSTATUS_FLAG_OFFSET)
#define ACTIVATION_CONTEXT_DATA_COM_SERVER_MISCSTATUS_HAS_DOCPRINT      (0x10 << ACTIVATION_CONTEXT_DATA_COM_SERVER_MISCSTATUS_FLAG_OFFSET)

typedef struct _ACTIVATION_CONTEXT_DATA_COM_SERVER_REDIRECTION {
    ULONG Size;
    ULONG Flags;
    ULONG ThreadingModel;
    GUID ReferenceClsid;
    GUID ConfiguredClsid;
    GUID ImplementedClsid;
    GUID TypeLibraryId;
    ULONG ModuleLength;
    ULONG ModuleOffset;
    ULONG ProgIdLength;
    ULONG ProgIdOffset;
    ULONG ShimDataLength;
    ULONG ShimDataOffset;
    ULONG MiscStatusDefault;
    ULONG MiscStatusContent;
    ULONG MiscStatusThumbnail;
    ULONG MiscStatusIcon;
    ULONG MiscStatusDocPrint;
} ACTIVATION_CONTEXT_DATA_COM_SERVER_REDIRECTION, *PACTIVATION_CONTEXT_DATA_COM_SERVER_REDIRECTION;

#define ACTIVATION_CONTEXT_DATA_COM_SERVER_REDIRECTION_SHIM_TYPE_OTHER (1)
#define ACTIVATION_CONTEXT_DATA_COM_SERVER_REDIRECTION_SHIM_TYPE_CLR_CLASS (2)

typedef struct _ACTIVATION_CONTEXT_DATA_COM_SERVER_REDIRECTION_SHIM {
    ULONG Size;
    ULONG Flags;
    ULONG Type;
    ULONG ModuleLength;
    ULONG ModuleOffset;
    ULONG TypeLength;
    ULONG TypeOffset;
    ULONG ShimVersionLength;
    ULONG ShimVersionOffset;
    ULONG DataLength;
    ULONG DataOffset;
} ACTIVATION_CONTEXT_DATA_COM_SERVER_REDIRECTION_SHIM, *PACTIVATION_CONTEXT_DATA_COM_SERVER_REDIRECTION_SHIM;

typedef struct _ACTIVATION_CONTEXT_DATA_COM_TYPE_LIBRARY_REDIRECTION {
    ULONG Size;
    ULONG Flags;
    ULONG NameLength;
    ULONG NameOffset;
    USHORT ResourceId;
    USHORT LibraryFlags;
    ULONG HelpDirLength;
    ULONG HelpDirOffset;
} ACTIVATION_CONTEXT_DATA_COM_TYPE_LIBRARY_REDIRECTION, *PACTIVATION_CONTEXT_DATA_COM_TYPE_LIBRARY_REDIRECTION;

typedef struct _ACTIVATION_CONTEXT_DATA_COM_PROGID_REDIRECTION {
    ULONG Size;
    ULONG Flags;
    ULONG ConfiguredClsidOffset;
} ACTIVATION_CONTEXT_DATA_COM_PROGID_REDIRECTION, *PACTIVATION_CONTEXT_DATA_COM_PROGID_REDIRECTION;

typedef struct _SXS_OVERRIDE_MANIFEST {
    PCWSTR  Name;
    PVOID   Address;
    SIZE_T  Size;
} SXS_OVERRIDE_MANIFEST, *PSXS_OVERRIDE_MANIFEST;

typedef struct _SXS_MANIFEST_STREAM {
    const IID* IIDStream;
    PVOID      OutIStream;
}SXS_MANIFEST_STREAM, *PSXS_MANIFEST_STREAM;

typedef struct _ACTIVATION_CONTEXT_ASSEMBLY_DATA {
    ULONG Size;
    ULONG Flags;
    WCHAR *AssemblyName;
    ULONG AssemblyNameLength;
    ULONG HashAlgorithm;
    ULONG PseudoKey;
} ACTIVATION_CONTEXT_ASSEMBLY_DATA, *PACTIVATION_CONTEXT_ASSEMBLY_DATA;

typedef struct _ACTIVATION_CONTEXT_DATA_ASSEMBLY_ROSTER_HEADER {
    ULONG HeaderSize;
    ULONG HashAlgorithm;
    ULONG EntryCount;
    ULONG FirstEntryOffset;
    ULONG AssemblyInformationSectionOffset;
} ACTIVATION_CONTEXT_DATA_ASSEMBLY_ROSTER_HEADER, *PACTIVATION_CONTEXT_DATA_ASSEMBLY_ROSTER_HEADER;

#define ACTIVATION_CONTEXT_DATA_ASSEMBLY_ROSTER_ENTRY_INVALID (0x00000001)
#define ACTIVATION_CONTEXT_DATA_ASSEMBLY_ROSTER_ENTRY_ROOT    (0x00000002)

typedef struct _ACTIVATION_CONTEXT_DATA_ASSEMBLY_ROSTER_ENTRY {
    ULONG Flags;
    ULONG PseudoKey;
    ULONG AssemblyNameOffset;
    ULONG AssemblyNameLength;
    ULONG AssemblyInformationOffset;
    ULONG AssemblyInformationLength;
} ACTIVATION_CONTEXT_DATA_ASSEMBLY_ROSTER_ENTRY, *PACTIVATION_CONTEXT_DATA_ASSEMBLY_ROSTER_ENTRY;

typedef struct _ACTIVATION_CONTEXT_SECTION_KEYED_DATA_ASSEMBLY_METADATA {
    PVOID Information;
    PVOID SectionBase;
    ULONG SectionLength;
    PVOID SectionGlobalDataBase;
    ULONG SectionGlobalDataLength;
} ACTIVATION_CONTEXT_SECTION_KEYED_DATA_ASSEMBLY_METADATA, *PACTIVATION_CONTEXT_SECTION_KEYED_DATA_ASSEMBLY_METADATA;

typedef struct _ACTIVATION_CONTEXT_SECTION_KEYED_DATA {
    ULONG Size;
    ULONG DataFormatVersion;
    PVOID Data;
    ULONG Length;
    PVOID SectionGlobalData;
    ULONG SectionGlobalDataLength;
    PVOID SectionBase;
    ULONG SectionTotalLength;
    PACTIVATION_CONTEXT ActivationContext;
    ULONG AssemblyRosterIndex;
    ULONG Flags;
    ACTIVATION_CONTEXT_SECTION_KEYED_DATA_ASSEMBLY_METADATA AssemblyMetadata;
} ACTIVATION_CONTEXT_SECTION_KEYED_DATA, *PACTIVATION_CONTEXT_SECTION_KEYED_DATA;

#define RTL_ACTIVATE_ACTIVATION_CONTEXT_EX_FLAG_RELEASE_ON_STACK_DEALLOCATION (0x00000001)

NTSYSAPI
NTSTATUS 
NTAPI 
RtlActivateActivationContextEx(
    _In_ ULONG Flags,
    _In_ PTEB Teb,
    _In_ PACTIVATION_CONTEXT ActivationContext,
    _Out_ PULONG_PTR Cookie);

NTSYSAPI
NTSTATUS 
NTAPI 
RtlQueryInformationActivationContext(
    _In_ ULONG Flags,
    _In_ PCACTIVATION_CONTEXT ActivationContext,
    _In_opt_ PVOID SubInstanceIndex,
    _In_ ACTIVATION_CONTEXT_INFO_CLASS ActivationContextInformationClass,
    _Out_ PVOID ActivationContextInformation,
    _In_ SIZE_T ActivationContextInformationLength,
    _Out_opt_ PSIZE_T ReturnLength);

NTSYSAPI
NTSTATUS 
NTAPI 
RtlQueryInformationActiveActivationContext(
    _In_ ACTIVATION_CONTEXT_INFO_CLASS ActivationContextInformationClass,
    _Out_ PVOID ActivationContextInformation,
    _In_ SIZE_T ActivationContextInformationLength,
    _Out_opt_ PSIZE_T ReturnLength);

NTSYSAPI
NTSTATUS 
NTAPI 
RtlAllocateActivationContextStack(
    _Inout_ PACTIVATION_CONTEXT_STACK *ActivationContextStackPointer);

NTSYSAPI
VOID 
NTAPI 
RtlFreeActivationContextStack(
    _In_ PACTIVATION_CONTEXT_STACK ActivationContextStackPointer);

NTSYSAPI
NTSTATUS 
NTAPI 
RtlCreateActivationContext(
    _In_ ULONG Flags,
    _In_ const PACTIVATION_CONTEXT_DATA ActivationContextData,
    _In_opt_ ULONG ExtraBytes,
    _In_opt_ PACTIVATION_CONTEXT_NOTIFY_ROUTINE NotificationRoutine,
    _In_opt_ PVOID NotificationContext,
    _Out_ PACTIVATION_CONTEXT *ActivationContext);

NTSYSAPI
VOID 
NTAPI 
RtlAddRefActivationContext(
    _In_ PACTIVATION_CONTEXT AppCtx);

NTSYSAPI
VOID 
NTAPI 
RtlReleaseActivationContext(
    _In_ PACTIVATION_CONTEXT AppCtx);

NTSYSAPI
NTSTATUS 
NTAPI 
RtlZombifyActivationContext(
    _In_ PACTIVATION_CONTEXT ActivationContext);

NTSYSAPI
NTSTATUS 
NTAPI 
RtlGetActiveActivationContext(
    _Out_ PACTIVATION_CONTEXT *ActivationContext);

NTSYSAPI
BOOLEAN 
NTAPI 
RtlIsActivationContextActive(
    _In_ PACTIVATION_CONTEXT ActivationContext);

NTSYSAPI
NTSTATUS
NTAPI 
RtlQueryActivationContextApplicationSettings(
    _In_opt_      DWORD dwFlags,
    _In_opt_      HANDLE hActCtx,
    _In_opt_      PCWSTR settingsNameSpace,
    _In_          PCWSTR settingName,
    _Out_writes_bytes_to_opt_(dwBuffer, *pdwWrittenOrRequired) PWSTR pvBuffer,
    _In_      SIZE_T dwBuffer,
    _Out_opt_ SIZE_T *pdwWrittenOrRequired);

NTSYSAPI
NTSTATUS 
NTAPI 
RtlFindActivationContextSectionString(
    _In_        ULONG Flags,
    _In_opt_    CONST GUID *ExtensionGuid,
    _In_        ULONG SectionId,
    _In_        PCUNICODE_STRING StringToFind,
    _Inout_     PACTIVATION_CONTEXT_SECTION_KEYED_DATA ReturnedData);

//
// NTSXS_RTL HEADER END
//

#pragma warning(pop)


#ifdef __cplusplus
}
#endif

#endif NTSXS_RTL
