# Token-Hunter

[![pipeline status](https://gitlab.com/gitlab-com/gl-security/security-operations/gl-redteam/token-hunter/badges/master/pipeline.svg)](https://gitlab.com/gitlab-com/gl-security/security-operations/gl-redteam/token-hunter/-/commits/master)

Collect OSINT for [GitLab groups](https://docs.gitlab.com/ee/user/group/) and [members](https://docs.gitlab.com/ee/user/project/members/#share-project-with-group) and search the groups GitLab assets for sensitive data. The information gathered is intended to compliment and inform the use of additional tools such as [GitLeaks](https://github.com/zricethezav/gitleaks) or [gitrob](https://github.com/michenriksen/gitrob), which search git commit history using a similar technique of regular expression matching.  

# How the tool works

Start by providing a group ID or project ID for your GitLab target.  You can find the group ID underneath the group name in the GitLab UI.  The project ID can be found in a similar location for a project.  Token-Hunter will use the groupID to find all associated projects for that group and, optionally, the groups members personal projects.  Configure the tool to look for sensitive data in assets related to the projects it finds.  Token-Hunter a [similar set of regular expressions as TruffleHog](https://github.com/dxa4481/truffleHogRegexes) with a few additions for GitLab specific tokens.  Token-Hunter depends on its own set of [easily configurable regular expressions](https://gitlab.com/gitlab-com/gl-security/gl-redteam/token-hunter/blob/master/regexes.json) for accuracy and effectiveness.

# GitLab Assets Supported

* [CI Job Logs](https://docs.gitlab.com/ee/ci/pipelines/)
* [Snippets](https://docs.gitlab.com/ee/user/snippets.html)
* [Issues](https://docs.gitlab.com/ee/user/project/issues/) and [issue discussions](https://docs.gitlab.com/ee/api/discussions.html#discussions-api)
* [Merge requests](https://docs.gitlab.com/ee/user/project/merge_requests/) and merge request discussions

# Usage

Before running the tool, you will need to [generate a GitLab Personal Access Token (PAT)](https://docs.gitlab.com/ee/user/profile/personal_access_tokens.html) and export it as an environment variable. This can be done as shown below (please select `api` in the `scopes` section):

```
export GITLAB_API_TOKEN=xxxxx
```

Next, clone the repository and install dependencies with:

```
git clone https://gitlab.com/gitlab-com/gl-security/gl-redteam/token-hunter.git
pip3 install -r ./requirements.txt
```

Then, you can run the tool and specify your options as follows:

```
usage: token-hunter.py [-h] (-g GROUP | -p PROJECT) [-u URL] [-m] [-s] [-i] [-r] [-j] [-d DEPTH] [-t] [-x PROXY] [-c CERT] [-l LOGFILE] [-e]

Search group and project repository assets for sensitive data. Collect OSINT for GitLab groups, projects, and, members.

options:
  -h, --help            show this help message and exit
  -g GROUP, --group GROUP
                        ID or HTML encoded name of a GitLab group. This option, by itself, will display group projects only.
  -p PROJECT, --project PROJECT
                        ID or HTML encoded name of a GitLab project. This option, by itself, will display project details only.
  -u URL, --url URL     An optional argument to specify the base URL of your GitLab instance. If the argument is not supplied, its defaulted to
                        'https://gitlab.com'
  -m, --members         Include group members and their personal projects and their related assets in the search for sensitive data.
  -s, --snippets        Searches found projects for GitLab Snippets with sensitive data.
  -i, --issues          Searches found projects for GitLab Issues and discussions/comments with sensitive data.
  -r, --mergerequests   Searches found projects for GitLab Merge Requests and discussions/comments with sensitive data.
  -j, --jobs            Searches each projects' public CI job logs for sensitive data starting with the most recent jobs that either succeeded or failed
  -d DEPTH, --depth DEPTH
                        Limit the number of requests across ALL targeted assets including group projects
  -t, --timestamp       Disables display of start/finish times and originating IP to the output
  -x PROXY, --proxy PROXY
                        Proxies all requests using the provided URI matching the scheme: http(s)://user:pass@10.10.10.10:8000
  -c CERT, --cert CERT  Used in tandem with -p (--proxy), this switch provides a fully qualified path to a certificate to verify TLS connections. Provide a fully
                        qualified path to the dynamic cert. Example: /Users/<username>/owasp_zap_root_ca.cer.
  -l LOGFILE, --logfile LOGFILE
                        Will APPEND all output to specified file.
  -e, --excludesubgroups
                        Exclude subgroups when scanning a group. Default behavior is to include subgroups.
```

# Usage Examples

`./token-hunter.py -g 123456`

One of the simplest use cases is to return all the project URLs associated with a group by providing the group ID with the `-g` switch.  You can find the group ID underneath the group name in the GitLab UI.  No token searches are performed with this configuration.

`./token-hunter.py -g 234567 -j`

Another simple use case is to search all job logs for a specific project with the `-p` switch.  You can find the project ID underneath the project name in the GitLab UI.

`./token-hunter.py -p 123456 -m`

Finds all projects for group 123456 as well as all of the personal projects for the group members.  No token searches are performed with this configuration.

`./token-hunter.py -g 123456 -ms`

Finds all projects for group 123456 as well as all of the personal projects for the group members.  The `-s` switch tells Token-Hunter to search GitLab snippets associated with each found project for sensitive data.

`./token-hunter.py -g 123456 -msirj`

Finds all projects for group 123456 as well as all of the personal projects for the group members.  The `-s` switch tells Token-Hunter to search GitLab snippets associated with each found project for sensitive data.  The `-i` switch tells Token-Hunter to also search issues and discussions for each of the found projects for sensitive data.  The `-r` switch tells Token-Hunter to also search merge requests and merge request discussions for each of the found projects.  The `-j` switch tells Token-Hunter to also search CI job logs for each project found.  **CAUTION:** This configuration has the potential to pull a lot of data!

`./token-hunter.py -g 123456 -msit -u https://mygitlab-instance.com -p http://127.0.01:8080 -c /Users/hacker/owasp_zap_ca_cert.cer -l ./appended-output.txt`

Performs the same asset searches as the previous example against a self-hosted installation of GitLab running at `https://mygitlab-instance.com`.  Requests and responses that the tool generates are proxied through `http://127.0.01:8080` using the certificate defined at the fully qualified path `/Users/hacker/owasp_zap_ca_cert.cer` to decrypt the TLS traffic.  Timestamps and origin IP are excluded from the output with the `-t` switch.  Output is *APPENDED* to the `./appended-output.txt` file with the `-l` switch.

# Contributing

Contributions are welcome from the community.  You can find and add to the issue list, submit merge requests, and add to the existing discussions.  Token-Hunter is written in python 3.  To make a code contribution:

1. [Install python version 3](https://realpython.com/installing-python/)
1. Install pip version 3 to manage dependencies using the guide above.
1. Clone the repository
1. In the root directory, install dependencies with `pip3 install -r ./requirements.txt`
1. [Create a branch](https://docs.gitlab.com/ee/gitlab-basics/create-branch.html) for the changes you'd like to make.
1. Modify or add test coverage in the existing `./test_*` files, adding new files as needed.
1. Execute tests, written in [pytest](http://doc.pytest.org/), with `pytest -v` to make sure they pass.
1. Create a merge requests for your changes and tag `@gitlab-com/gl-security/security-operations/gl-redteam` to review and merge it.
1. Repeat!
