/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow.action;

import de.rub.nds.tlsattacker.core.exceptions.ActionExecutionException;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.workflow.action.TlsAction;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@XmlRootElement(name="Wait")
public class WaitAction
extends TlsAction {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final long DEFAULT_WAITING_TIME = 10L;
    private Boolean asPlanned;
    private Long time = -1L;

    public WaitAction(long time) {
        this.time = time;
    }

    public WaitAction() {
    }

    @Override
    public void execute(State state) throws ActionExecutionException {
        if (this.isExecuted()) {
            throw new ActionExecutionException("Action already executed!");
        }
        LOGGER.info("Waiting {} ms...", (Object)this.time);
        try {
            if (this.time > 0L) {
                Thread.sleep(this.time);
            }
            this.asPlanned = true;
        }
        catch (InterruptedException ex) {
            LOGGER.error((Object)ex);
            this.asPlanned = false;
        }
        this.setExecuted(true);
    }

    @Override
    public void reset() {
        this.setExecuted(false);
        this.asPlanned = null;
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    @Override
    public boolean executedAsPlanned() {
        return this.isExecuted() && Objects.equals(this.asPlanned, Boolean.TRUE);
    }

    @Override
    public void normalize() {
        if (this.time == null || this.time < 0L) {
            this.time = 10L;
        }
        super.normalize();
    }

    @Override
    public void normalize(TlsAction defaultAction) {
        super.normalize(defaultAction);
        if (defaultAction instanceof WaitAction && (this.time == null || this.time < 0L)) {
            this.time = ((WaitAction)defaultAction).getTime();
        }
        if (this.time == null || this.time < 0L) {
            this.time = 10L;
        }
    }

    @Override
    public void filter() {
        if (this.time == 10L) {
            this.time = null;
        }
    }

    @Override
    public void filter(TlsAction defaultAction) {
        WaitAction a;
        long defaultTime = 10L;
        if (defaultAction instanceof WaitAction && (a = (WaitAction)defaultAction).getTime() >= 0L) {
            defaultTime = a.getTime();
        }
        if (this.time == defaultTime) {
            this.time = null;
        }
    }

    public int hashCode() {
        int hash = 3;
        hash = 23 * hash + Objects.hashCode(this.time);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WaitAction other = (WaitAction)obj;
        return Objects.equals(this.time, other.time);
    }
}

