/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow.action;

import de.rub.nds.modifiablevariable.util.DataConverter;
import de.rub.nds.modifiablevariable.util.Modifiable;
import de.rub.nds.tlsattacker.core.layer.LayerConfiguration;
import de.rub.nds.tlsattacker.core.layer.SpecificSendLayerConfiguration;
import de.rub.nds.tlsattacker.core.layer.constant.ImplementedLayers;
import de.rub.nds.tlsattacker.core.layer.constant.LayerType;
import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.layer.data.DataContainer;
import de.rub.nds.tlsattacker.core.protocol.ProtocolMessage;
import de.rub.nds.tlsattacker.core.protocol.message.ClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.DHClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.workflow.action.CommonSendAction;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import de.rub.nds.tlsattacker.core.workflow.container.ActionHelperUtil;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.math.BigInteger;
import java.util.LinkedList;
import java.util.List;

@XmlRootElement(name="SendRaccoonCke")
public class SendRaccoonCkeAction
extends CommonSendAction {
    private boolean withNullByte = true;
    private BigInteger initialSecret = new BigInteger("5000");

    public SendRaccoonCkeAction() {
    }

    public SendRaccoonCkeAction(boolean withNullByte, BigInteger initialSecret) {
        this.withNullByte = withNullByte;
        this.initialSecret = initialSecret;
    }

    public SendRaccoonCkeAction(String connectionAlias) {
        super(connectionAlias);
    }

    public BigInteger getInitialSecret() {
        return this.initialSecret;
    }

    public void setInitialSecret(BigInteger initialSecret) {
        this.initialSecret = initialSecret;
    }

    public boolean isWithNullByte() {
        return this.withNullByte;
    }

    public void setWithNullByte(boolean withNullByte) {
        this.withNullByte = withNullByte;
    }

    private DHClientKeyExchangeMessage generateRaccoonDhClientKeyExchangeMessage(TlsContext context, boolean withNullByte) {
        DHClientKeyExchangeMessage cke = new DHClientKeyExchangeMessage();
        Chooser chooser = context.getChooser();
        byte[] clientPublicKey = chooser.getSelectedCipherSuite().isEphemeral() ? this.getClientPublicKey(chooser.getServerEphemeralDhGenerator(), chooser.getServerEphemeralDhModulus(), chooser.getServerEphemeralDhPublicKey(), this.initialSecret, withNullByte) : this.getClientPublicKey(chooser.getServerX509Chooser().getSubjectDhGenerator(), chooser.getServerX509Chooser().getSubjectDhModulus(), chooser.getServerX509Chooser().getSubjectDhPublicKey(), this.initialSecret, withNullByte);
        cke.setPublicKey(Modifiable.explicit((byte[])clientPublicKey));
        return cke;
    }

    private byte[] getClientPublicKey(BigInteger g, BigInteger m, BigInteger serverPublicKey, BigInteger initialClientDhSecret, boolean withNullByte) {
        BigInteger clientPublicKey;
        byte[] cke;
        int length = DataConverter.bigIntegerToByteArray((BigInteger)m).length;
        byte[] pms = DataConverter.bigIntegerToNullPaddedByteArray((BigInteger)serverPublicKey.modPow(initialClientDhSecret, m), (int)length);
        if ((withNullByte && pms[0] == 0 && pms[1] != 0 || !withNullByte && pms[0] != 0) && (cke = DataConverter.bigIntegerToByteArray((BigInteger)(clientPublicKey = g.modPow(initialClientDhSecret, m)))).length == length) {
            return cke;
        }
        initialClientDhSecret = initialClientDhSecret.add(BigInteger.ONE);
        return this.getClientPublicKey(g, m, serverPublicKey, initialClientDhSecret, withNullByte);
    }

    public String toString() {
        StringBuilder sb = this.isExecuted() ? new StringBuilder("Send Raccoon DH-CKE Action:\n") : new StringBuilder("Send Raccoon DH-CKE: (not executed)\n");
        sb.append("\tMessages:");
        if (this.getSentMessages() != null) {
            for (ProtocolMessage message : this.getSentMessages()) {
                sb.append(message.toCompactString());
                sb.append(", ");
            }
            sb.append("\n");
        } else {
            sb.append("null (no messages set)");
        }
        return sb.toString();
    }

    @Override
    public String toCompactString() {
        StringBuilder sb = new StringBuilder(super.toCompactString());
        if (this.getSentMessages() != null && !this.getSentMessages().isEmpty()) {
            sb.append(" (");
            for (ProtocolMessage message : this.getSentMessages()) {
                sb.append(message.toCompactString());
                sb.append(",");
            }
            sb.deleteCharAt(sb.lastIndexOf(",")).append(")");
        } else {
            sb.append(" (no messages set)");
        }
        return sb.toString();
    }

    @Override
    protected List<LayerConfiguration<?>> createLayerConfiguration(State state) {
        TlsContext tlsContext = state.getTlsContext(this.getConnectionAlias());
        DHClientKeyExchangeMessage message = this.generateRaccoonDhClientKeyExchangeMessage(tlsContext, this.withNullByte);
        LinkedList configurationList = new LinkedList();
        configurationList.add(new SpecificSendLayerConfiguration((LayerType)ImplementedLayers.MESSAGE, (DataContainer[])new ClientKeyExchangeMessage[]{message}));
        return ActionHelperUtil.sortAndAddOptions(tlsContext.getLayerStack(), true, this.getActionOptions(), configurationList);
    }
}

