/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow.action;

import de.rub.nds.tlsattacker.core.constants.CipherSuite;
import de.rub.nds.tlsattacker.core.layer.LayerConfiguration;
import de.rub.nds.tlsattacker.core.layer.SpecificSendLayerConfiguration;
import de.rub.nds.tlsattacker.core.layer.constant.ImplementedLayers;
import de.rub.nds.tlsattacker.core.layer.constant.LayerType;
import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.layer.data.DataContainer;
import de.rub.nds.tlsattacker.core.protocol.ProtocolMessage;
import de.rub.nds.tlsattacker.core.protocol.message.CertificateMessage;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.workflow.action.CommonSendAction;
import de.rub.nds.tlsattacker.core.workflow.container.ActionHelperUtil;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.LinkedList;
import java.util.List;

@XmlRootElement(name="SendDynamicServerCertificate")
public class SendDynamicServerCertificateAction
extends CommonSendAction {
    public SendDynamicServerCertificateAction() {
    }

    public SendDynamicServerCertificateAction(String connectionAlias) {
        super(connectionAlias);
    }

    public String toString() {
        StringBuilder sb;
        if (this.isExecuted()) {
            sb = new StringBuilder("Send Dynamic Certificate Action:\n");
            sb.append("\tMessages:");
            if (this.getSentMessages() != null) {
                for (ProtocolMessage message : this.getSentMessages()) {
                    sb.append(message.toCompactString());
                    sb.append(", ");
                }
                sb.append("\n");
            } else {
                sb.append("null (no messages set)");
            }
        } else {
            sb = new StringBuilder("Send Dynamic Certificate: (not executed)\n");
        }
        return sb.toString();
    }

    @Override
    public String toCompactString() {
        StringBuilder sb = new StringBuilder(super.toCompactString());
        if (this.getSentMessages() != null && !this.getSentMessages().isEmpty()) {
            sb.append(" (");
            for (ProtocolMessage message : this.getSentMessages()) {
                sb.append(message.toCompactString());
                sb.append(",");
            }
            sb.deleteCharAt(sb.lastIndexOf(",")).append(")");
        } else {
            sb.append(" (no messages set)");
        }
        return sb.toString();
    }

    @Override
    protected List<LayerConfiguration<?>> createLayerConfiguration(State state) {
        TlsContext tlsContext = state.getTlsContext(this.getConnectionAlias());
        CipherSuite selectedCipherSuite = tlsContext.getChooser().getSelectedCipherSuite();
        if (selectedCipherSuite.requiresServerCertificateMessage()) {
            LinkedList configurationList = new LinkedList();
            configurationList.add(new SpecificSendLayerConfiguration((LayerType)ImplementedLayers.MESSAGE, (DataContainer[])new CertificateMessage[]{new CertificateMessage()}));
            return ActionHelperUtil.sortAndAddOptions(tlsContext.getLayerStack(), true, this.getActionOptions(), configurationList);
        }
        return null;
    }
}

