/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow.action;

import de.rub.nds.tlsattacker.core.dtls.DtlsHandshakeMessageFragment;
import de.rub.nds.tlsattacker.core.layer.LayerConfiguration;
import de.rub.nds.tlsattacker.core.layer.SpecificSendLayerConfiguration;
import de.rub.nds.tlsattacker.core.layer.constant.ImplementedLayers;
import de.rub.nds.tlsattacker.core.layer.constant.LayerType;
import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.layer.data.DataContainer;
import de.rub.nds.tlsattacker.core.protocol.ProtocolMessage;
import de.rub.nds.tlsattacker.core.protocol.message.ClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.workflow.action.CommonSendAction;
import de.rub.nds.tlsattacker.core.workflow.container.ActionHelperUtil;
import de.rub.nds.tlsattacker.core.workflow.factory.WorkflowConfigurationFactory;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.LinkedList;
import java.util.List;
import java.util.StringJoiner;

@XmlRootElement(name="SendDynamicClientKeyExchange")
public class SendDynamicClientKeyExchangeAction
extends CommonSendAction {
    private List<DtlsHandshakeMessageFragment> configuredFragmentList = null;

    public SendDynamicClientKeyExchangeAction() {
    }

    public SendDynamicClientKeyExchangeAction(String connectionAlias) {
        super(connectionAlias);
    }

    public List<DtlsHandshakeMessageFragment> getConfiguredFragmentList() {
        return this.configuredFragmentList;
    }

    public void setConfiguredFragmentList(List<DtlsHandshakeMessageFragment> configuredFragmentList) {
        this.configuredFragmentList = configuredFragmentList;
    }

    public String toString() {
        StringBuilder sb;
        if (this.isExecuted()) {
            sb = new StringBuilder("Send Dynamic Client Key Exchange Action:\n");
            sb.append("\tMessages:");
            if (this.getSentMessages() != null) {
                StringJoiner joiner = new StringJoiner(", ");
                for (ProtocolMessage message : this.getSentMessages()) {
                    joiner.add(message.toCompactString());
                }
                sb.append(joiner.toString());
            } else {
                sb.append("null (no messages set)");
            }
        } else {
            sb = new StringBuilder("Send Dynamic Client Key Exchange Action: (not executed)\n");
        }
        return sb.toString();
    }

    @Override
    public String toCompactString() {
        StringBuilder sb = new StringBuilder(super.toCompactString());
        if (this.getSentMessages() != null && !this.getSentMessages().isEmpty()) {
            sb.append(" (");
            StringJoiner joiner = new StringJoiner(", ");
            for (ProtocolMessage message : this.getSentMessages()) {
                joiner.add(message.toCompactString());
            }
            sb.append(joiner.toString());
            sb.append(")");
        } else {
            sb.append(" (no messages set)");
        }
        return sb.toString();
    }

    @Override
    protected List<LayerConfiguration<?>> createLayerConfiguration(State state) {
        TlsContext tlsContext = state.getTlsContext(this.getConnectionAlias());
        ClientKeyExchangeMessage clientKeyExchangeMessage = new WorkflowConfigurationFactory(tlsContext.getConfig()).createClientKeyExchangeMessage(tlsContext.getChooser().getSelectedCipherSuite().getKeyExchangeAlgorithm());
        if (clientKeyExchangeMessage != null) {
            LinkedList configurationList = new LinkedList();
            configurationList.add(new SpecificSendLayerConfiguration((LayerType)ImplementedLayers.MESSAGE, (DataContainer[])new ClientKeyExchangeMessage[]{clientKeyExchangeMessage}));
            if (this.configuredFragmentList != null) {
                configurationList.add(new SpecificSendLayerConfiguration<DtlsHandshakeMessageFragment>((LayerType)ImplementedLayers.DTLS_FRAGMENT, this.configuredFragmentList));
            }
            return ActionHelperUtil.sortAndAddOptions(tlsContext.getLayerStack(), true, this.getActionOptions(), configurationList);
        }
        return null;
    }
}

