/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow.action;

import de.rub.nds.tlsattacker.core.exceptions.ActionExecutionException;
import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.layer.impl.RecordLayer;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.workflow.action.ConnectionBoundAction;
import jakarta.xml.bind.annotation.XmlRootElement;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@XmlRootElement(name="ResetRecordCipherLists")
public class ResetRecordCipherListsAction
extends ConnectionBoundAction {
    private static final Logger LOGGER = LogManager.getLogger();
    private final int toRemoveEncryptor;
    private final int toRemoveDecryptor;

    public ResetRecordCipherListsAction(int toRemoveEncryptor, int toRemoveDecryptor) {
        this.toRemoveEncryptor = toRemoveEncryptor;
        this.toRemoveDecryptor = toRemoveDecryptor;
    }

    public ResetRecordCipherListsAction() {
        this.toRemoveDecryptor = 1;
        this.toRemoveEncryptor = 1;
    }

    @Override
    public void execute(State state) throws ActionExecutionException {
        TlsContext context = state.getContext(this.getConnectionAlias()).getTlsContext();
        if (this.isExecuted()) {
            throw new ActionExecutionException("Action already executed!");
        }
        RecordLayer recordLayer = context.getRecordLayer();
        if (recordLayer != null) {
            recordLayer.getEncryptor().removeCiphers(this.toRemoveEncryptor);
            recordLayer.getDecryptor().removeCiphers(this.toRemoveDecryptor);
        } else {
            LOGGER.warn("The current context does not have a Record Layer");
        }
        this.setExecuted(true);
    }

    @Override
    public void reset() {
    }

    @Override
    public boolean executedAsPlanned() {
        return this.isExecuted();
    }
}

