/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow.action;

import de.rub.nds.modifiablevariable.util.IllegalStringAdapter;
import de.rub.nds.tlsattacker.core.exceptions.ActionExecutionException;
import de.rub.nds.tlsattacker.core.layer.context.TcpContext;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.workflow.action.AsciiAction;
import de.rub.nds.tlsattacker.core.workflow.action.executor.ActionOption;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.IOException;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@XmlRootElement(name="ReceiveAscii")
public class ReceiveAsciiAction
extends AsciiAction {
    private static final Logger LOGGER = LogManager.getLogger();
    @XmlJavaTypeAdapter(value=IllegalStringAdapter.class)
    private String receivedAsciiString;

    public ReceiveAsciiAction() {
    }

    public ReceiveAsciiAction(String asciiText, String encoding) {
        super(asciiText, encoding);
        this.receivedAsciiString = null;
    }

    @Override
    public void execute(State state) throws ActionExecutionException {
        TcpContext tcpContext = state.getTcpContext();
        if (this.isExecuted()) {
            throw new ActionExecutionException("Action already executed!");
        }
        try {
            LOGGER.debug("Receiving ASCII message...");
            byte[] fetchData = tcpContext.getTransportHandler().fetchData();
            this.receivedAsciiString = new String(fetchData, this.getEncoding());
            LOGGER.info("Received: {}", (Object)this.receivedAsciiString);
            this.setExecuted(true);
        }
        catch (IOException e) {
            LOGGER.debug((Object)e);
            this.setExecuted(this.getActionOptions().contains((Object)ActionOption.MAY_FAIL));
        }
    }

    public String getReceivedAsciiString() {
        return this.receivedAsciiString;
    }

    @Override
    public void reset() {
        this.setExecuted(null);
    }

    @Override
    public boolean executedAsPlanned() {
        return Objects.equals(this.receivedAsciiString, this.getAsciiText());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ReceiveAsciiAction that = (ReceiveAsciiAction)o;
        return Objects.equals(this.receivedAsciiString, that.receivedAsciiString);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.receivedAsciiString);
    }
}

