/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow.action;

import de.rub.nds.modifiablevariable.util.DataConverter;
import de.rub.nds.tlsattacker.core.exceptions.ActionExecutionException;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.workflow.action.ConnectionBoundAction;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.nio.charset.Charset;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@XmlRootElement(name="PrintLastHandledApplicationData")
public class PrintLastHandledApplicationDataAction
extends ConnectionBoundAction {
    private static final Logger LOGGER = LogManager.getLogger();
    private String lastHandledApplicationData = null;
    private String stringEncoding = null;

    public PrintLastHandledApplicationDataAction() {
    }

    public PrintLastHandledApplicationDataAction(String connectionAlias) {
        super(connectionAlias);
    }

    @Override
    public void execute(State state) throws ActionExecutionException {
        if (this.isExecuted()) {
            throw new ActionExecutionException("Action already executed!");
        }
        byte[] rawBytes = state.getTlsContext(this.getConnectionAlias()).getLastHandledApplicationMessageData();
        if (rawBytes != null) {
            this.lastHandledApplicationData = this.stringEncoding != null ? new String(rawBytes, Charset.forName(this.stringEncoding)) : DataConverter.bytesToRawHexString((byte[])rawBytes);
            LOGGER.info("Last handled application data: {}", (Object)this.lastHandledApplicationData);
        } else {
            LOGGER.info("Did not receive application data yet");
        }
        this.setExecuted(true);
    }

    public String getLastHandledApplicationData() {
        return this.lastHandledApplicationData;
    }

    public void setLastHandledApplicationData(String lastHandledApplicationData) {
        this.lastHandledApplicationData = lastHandledApplicationData;
    }

    public String getStringEncoding() {
        return this.stringEncoding;
    }

    public void setStringEncoding(String stringEncoding) {
        this.stringEncoding = stringEncoding;
    }

    @Override
    public boolean executedAsPlanned() {
        return this.isExecuted();
    }

    @Override
    public void reset() {
        this.setExecuted(false);
        this.lastHandledApplicationData = null;
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 53 * hash + Objects.hashCode(this.lastHandledApplicationData);
        hash = 53 * hash + Objects.hashCode(this.stringEncoding);
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PrintLastHandledApplicationDataAction other = (PrintLastHandledApplicationDataAction)obj;
        if (!Objects.equals(this.lastHandledApplicationData, other.lastHandledApplicationData)) {
            return false;
        }
        return Objects.equals(this.stringEncoding, other.stringEncoding);
    }
}

