/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow.action;

import de.rub.nds.tlsattacker.core.exceptions.ActionExecutionException;
import de.rub.nds.tlsattacker.core.layer.LayerConfiguration;
import de.rub.nds.tlsattacker.core.layer.context.TcpContext;
import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.record.Record;
import de.rub.nds.tlsattacker.core.record.serializer.RecordSerializer;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.workflow.action.CommonSendAction;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@XmlRootElement(name="PopAndSendRecord")
public class PopAndSendRecordAction
extends CommonSendAction {
    private static final Logger LOGGER = LogManager.getLogger();
    private Boolean asPlanned = null;

    public PopAndSendRecordAction() {
    }

    public PopAndSendRecordAction(String connectionAlias) {
        super(connectionAlias);
    }

    @Override
    public void execute(State state) throws ActionExecutionException {
        TlsContext tlsContext = state.getContext(this.connectionAlias).getTlsContext();
        TcpContext tcpContext = state.getContext(this.connectionAlias).getTcpContext();
        if (this.isExecuted()) {
            throw new ActionExecutionException("Action already executed!");
        }
        Record record = tlsContext.getRecordBuffer().pop();
        String sending = record.getContentMessageType().name();
        if (this.connectionAlias == null) {
            LOGGER.info("Sending record: {}", (Object)sending);
        } else {
            LOGGER.info("Sending record({}): {}", (Object)this.connectionAlias, (Object)sending);
        }
        RecordSerializer s = record.getRecordSerializer();
        try {
            tcpContext.getTransportHandler().sendData(s.serialize());
            this.asPlanned = true;
        }
        catch (IOException ex) {
            LOGGER.debug((Object)ex);
            tlsContext.setReceivedTransportHandlerException(true);
            this.asPlanned = false;
        }
        this.setExecuted(true);
    }

    public String toString() {
        return "PopAndSendRecordAction";
    }

    @Override
    public boolean executedAsPlanned() {
        return super.executedAsPlanned() && Objects.equals(this.asPlanned, Boolean.TRUE);
    }

    @Override
    public void reset() {
        super.reset();
        this.asPlanned = null;
    }

    @Override
    protected List<LayerConfiguration<?>> createLayerConfiguration(State state) {
        throw new UnsupportedOperationException("Unimplemented method 'createLayerConfiguration'");
    }
}

