/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow.action;

import de.rub.nds.protocol.exception.ConfigurationException;
import de.rub.nds.tlsattacker.core.workflow.action.TlsAction;
import de.rub.nds.tlsattacker.core.workflow.action.executor.ActionOption;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlTransient;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@XmlAccessorType(value=XmlAccessType.FIELD)
public abstract class ConnectionBoundAction
extends TlsAction {
    protected String connectionAlias = null;
    @XmlTransient
    private final Set<String> aliases = new HashSet<String>();

    public ConnectionBoundAction() {
    }

    public ConnectionBoundAction(String alias) {
        this.connectionAlias = alias;
    }

    public ConnectionBoundAction(Set<ActionOption> actionOptions, String alias) {
        super(actionOptions);
        this.connectionAlias = alias;
    }

    public ConnectionBoundAction(Set<ActionOption> actionOptions) {
        super(actionOptions);
    }

    public String getConnectionAlias() {
        return this.connectionAlias;
    }

    public void setConnectionAlias(String connectionAlias) {
        this.connectionAlias = connectionAlias;
    }

    public boolean hasDefaultAlias() {
        return this.getConnectionAlias().equals("defaultConnection");
    }

    @Override
    public String getFirstAlias() {
        return this.connectionAlias;
    }

    @Override
    public Set<String> getAllAliases() {
        if (this.aliases.isEmpty() && this.connectionAlias != null && !this.connectionAlias.isEmpty()) {
            this.aliases.add(this.connectionAlias);
        }
        return this.aliases;
    }

    @Override
    public boolean containsAllAliases(Collection<String> aliases) {
        return this.getAllAliases().containsAll(aliases);
    }

    @Override
    public boolean containsAlias(String alias) {
        return this.getAllAliases().contains(alias);
    }

    @Override
    public void assertAliasesSetProperly() throws ConfigurationException {
        if (this.connectionAlias == null || this.connectionAlias.isEmpty()) {
            throw new ConfigurationException("connectionAlias empty or null in " + this.getClass().getSimpleName());
        }
    }

    @Override
    public void normalize() {
        if (this.connectionAlias == null || this.connectionAlias.isEmpty()) {
            this.connectionAlias = "defaultConnection";
        }
    }

    @Override
    public void normalize(TlsAction defaultAction) {
        if (this.connectionAlias == null || this.connectionAlias.isEmpty()) {
            this.connectionAlias = defaultAction.getFirstAlias();
            this.normalize();
        }
    }

    @Override
    public void filter() {
        if (!this.isSingleConnectionWorkflow().booleanValue() || this.connectionAlias == null) {
            return;
        }
        if (this.connectionAlias.equals("defaultConnection")) {
            this.connectionAlias = null;
        }
    }

    @Override
    public void filter(TlsAction defaultCon) {
        if (!this.isSingleConnectionWorkflow().booleanValue() || this.connectionAlias == null) {
            return;
        }
        String defaultAlias = defaultCon.getFirstAlias();
        if (defaultAlias == null) {
            defaultAlias = "defaultConnection";
        }
        if (this.connectionAlias.equals(defaultAlias)) {
            this.connectionAlias = null;
        }
    }

    public int hashCode() {
        int hash = 3;
        hash = 79 * hash + Objects.hashCode(this.connectionAlias);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConnectionBoundAction other = (ConnectionBoundAction)obj;
        return Objects.equals(this.connectionAlias, other.connectionAlias);
    }
}

