/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow.action;

import de.rub.nds.protocol.exception.ConfigurationException;
import de.rub.nds.tlsattacker.core.dtls.DtlsHandshakeMessageFragment;
import de.rub.nds.tlsattacker.core.exceptions.ActionExecutionException;
import de.rub.nds.tlsattacker.core.http.HttpMessage;
import de.rub.nds.tlsattacker.core.layer.LayerConfiguration;
import de.rub.nds.tlsattacker.core.layer.LayerStackProcessingResult;
import de.rub.nds.tlsattacker.core.layer.constant.ImplementedLayers;
import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.layer.data.DataContainer;
import de.rub.nds.tlsattacker.core.printer.LogPrinter;
import de.rub.nds.tlsattacker.core.protocol.ProtocolMessage;
import de.rub.nds.tlsattacker.core.protocol.message.SSL2Message;
import de.rub.nds.tlsattacker.core.quic.frame.QuicFrame;
import de.rub.nds.tlsattacker.core.quic.packet.QuicPacket;
import de.rub.nds.tlsattacker.core.record.Record;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.tcp.TcpStreamContainer;
import de.rub.nds.tlsattacker.core.udp.UdpDataPacket;
import de.rub.nds.tlsattacker.core.workflow.action.ReceivingAction;
import de.rub.nds.tlsattacker.core.workflow.action.SendingAction;
import de.rub.nds.tlsattacker.core.workflow.action.TlsAction;
import de.rub.nds.tlsattacker.core.workflow.container.ActionHelperUtil;
import jakarta.xml.bind.annotation.XmlElement;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class CommonForwardAction
extends TlsAction
implements ReceivingAction,
SendingAction {
    private static final Logger LOGGER = LogManager.getLogger();
    @XmlElement(name="from")
    protected String receiveFromAlias = null;
    @XmlElement(name="to")
    protected String forwardToAlias = null;
    @XmlElement(name="receiveResult")
    private LayerStackProcessingResult layerStackReceiveResult;
    @XmlElement(name="sendResult")
    private LayerStackProcessingResult layerStackSendResult;

    public CommonForwardAction() {
    }

    public CommonForwardAction(String receiveFromAlias, String forwardToAlias) {
        this.receiveFromAlias = receiveFromAlias;
        this.forwardToAlias = forwardToAlias;
    }

    public void setReceiveFromAlias(String receiveFromAlias) {
        this.receiveFromAlias = receiveFromAlias;
    }

    public void setForwardToAlias(String forwardToAlias) {
        this.forwardToAlias = forwardToAlias;
    }

    public String getReceiveFromAlias() {
        return this.receiveFromAlias;
    }

    public String getForwardToAlias() {
        return this.forwardToAlias;
    }

    @Override
    public void execute(State state) throws ActionExecutionException {
        if (this.isExecuted()) {
            throw new ActionExecutionException("Action already executed!");
        }
        this.assertAliasesSetProperly();
        TlsContext receiveFromContext = state.getTlsContext(this.receiveFromAlias);
        TlsContext forwardToContext = state.getTlsContext(this.forwardToAlias);
        List<LayerConfiguration<? extends DataContainer>> layerConfigurationList = this.createReceiveConfiguration(state);
        if (layerConfigurationList == null) {
            LOGGER.info("Not receiving messages");
        } else {
            LOGGER.info("Receiving messages ({}): {}", (Object)this.receiveFromAlias, (Object)LogPrinter.toHumanReadableOneLine(layerConfigurationList, LOGGER.getLevel()));
            this.layerStackReceiveResult = receiveFromContext.getLayerStack().receiveData(layerConfigurationList);
        }
        layerConfigurationList = this.createSendConfiguration(state, this.layerStackReceiveResult);
        try {
            this.layerStackSendResult = forwardToContext.getLayerStack().sendData(layerConfigurationList);
        }
        catch (IOException e) {
            forwardToContext.setReceivedTransportHandlerException(true);
            LOGGER.debug("Failed execution", (Throwable)e);
        }
        this.setExecuted(true);
    }

    @Override
    public boolean executedAsPlanned() {
        return this.layerStackReceiveResult != null && this.layerStackSendResult != null && this.layerStackReceiveResult.executedAsPlanned() && this.layerStackSendResult.executedAsPlanned();
    }

    @Override
    public void reset() {
        this.layerStackReceiveResult = null;
        this.layerStackSendResult = null;
        this.setExecuted(null);
    }

    @Override
    public Set<String> getAllAliases() {
        LinkedHashSet<String> aliases = new LinkedHashSet<String>();
        aliases.add(this.forwardToAlias);
        aliases.add(this.receiveFromAlias);
        return aliases;
    }

    @Override
    public Set<String> getAllSendingAliases() {
        return new HashSet<String>(Collections.singleton(this.forwardToAlias));
    }

    @Override
    public Set<String> getAllReceivingAliases() {
        return new HashSet<String>(Collections.singleton(this.receiveFromAlias));
    }

    @Override
    public void assertAliasesSetProperly() throws ConfigurationException {
        if (this.receiveFromAlias == null || this.receiveFromAlias.isEmpty()) {
            throw new ActionExecutionException("Can't execute " + this.getClass().getSimpleName() + " with empty receive alias (if using XML: add <from/>)");
        }
        if (this.forwardToAlias == null || this.forwardToAlias.isEmpty()) {
            throw new ActionExecutionException("Can't execute " + this.getClass().getSimpleName() + " with empty forward alias (if using XML: add <to/>)");
        }
    }

    protected abstract List<LayerConfiguration<?>> createReceiveConfiguration(State var1);

    protected abstract List<LayerConfiguration<?>> createSendConfiguration(State var1, LayerStackProcessingResult var2);

    @Override
    public List<ProtocolMessage> getReceivedMessages() {
        if (this.layerStackReceiveResult == null) {
            return null;
        }
        return ActionHelperUtil.getDataContainersForLayer(ImplementedLayers.MESSAGE, this.layerStackReceiveResult).stream().map(container -> (ProtocolMessage)container).collect(Collectors.toList());
    }

    @Override
    public List<SSL2Message> getReceivedSSL2Messages() {
        if (this.layerStackReceiveResult == null) {
            return null;
        }
        return ActionHelperUtil.getDataContainersForLayer(ImplementedLayers.SSL2, this.layerStackReceiveResult).stream().map(container -> (SSL2Message)container).collect(Collectors.toList());
    }

    @Override
    public List<Record> getReceivedRecords() {
        if (this.layerStackReceiveResult == null) {
            return null;
        }
        return ActionHelperUtil.getDataContainersForLayer(ImplementedLayers.RECORD, this.layerStackReceiveResult).stream().map(container -> (Record)container).collect(Collectors.toList());
    }

    @Override
    public List<DtlsHandshakeMessageFragment> getReceivedFragments() {
        if (this.layerStackReceiveResult == null) {
            return null;
        }
        return ActionHelperUtil.getDataContainersForLayer(ImplementedLayers.DTLS_FRAGMENT, this.layerStackReceiveResult).stream().map(container -> (DtlsHandshakeMessageFragment)container).collect(Collectors.toList());
    }

    @Override
    public List<HttpMessage> getReceivedHttpMessages() {
        if (this.layerStackReceiveResult == null) {
            return null;
        }
        return ActionHelperUtil.getDataContainersForLayer(ImplementedLayers.HTTP, this.layerStackReceiveResult).stream().map(container -> (HttpMessage)container).collect(Collectors.toList());
    }

    @Override
    public List<QuicFrame> getReceivedQuicFrames() {
        if (this.layerStackReceiveResult == null) {
            return null;
        }
        return ActionHelperUtil.getDataContainersForLayer(ImplementedLayers.QUICFRAME, this.layerStackReceiveResult).stream().map(container -> (QuicFrame)container).collect(Collectors.toList());
    }

    @Override
    public List<QuicPacket> getReceivedQuicPackets() {
        if (this.layerStackReceiveResult == null) {
            return null;
        }
        return ActionHelperUtil.getDataContainersForLayer(ImplementedLayers.QUICPACKET, this.layerStackReceiveResult).stream().map(container -> (QuicPacket)container).collect(Collectors.toList());
    }

    @Override
    public final List<DtlsHandshakeMessageFragment> getSentFragments() {
        if (this.layerStackSendResult == null) {
            return null;
        }
        return ActionHelperUtil.getDataContainersForLayer(ImplementedLayers.DTLS_FRAGMENT, this.layerStackSendResult).stream().map(container -> (DtlsHandshakeMessageFragment)container).collect(Collectors.toList());
    }

    @Override
    public final List<ProtocolMessage> getSentMessages() {
        if (this.layerStackSendResult == null) {
            return null;
        }
        return ActionHelperUtil.getDataContainersForLayer(ImplementedLayers.MESSAGE, this.layerStackSendResult).stream().map(container -> (ProtocolMessage)container).collect(Collectors.toList());
    }

    @Override
    public final List<SSL2Message> getSentSSL2Messages() {
        if (this.layerStackSendResult == null) {
            return null;
        }
        return ActionHelperUtil.getDataContainersForLayer(ImplementedLayers.SSL2, this.layerStackSendResult).stream().map(container -> (SSL2Message)container).collect(Collectors.toList());
    }

    @Override
    public final List<QuicFrame> getSentQuicFrames() {
        if (this.layerStackSendResult == null) {
            return null;
        }
        return ActionHelperUtil.getDataContainersForLayer(ImplementedLayers.QUICFRAME, this.layerStackSendResult).stream().map(container -> (QuicFrame)container).collect(Collectors.toList());
    }

    @Override
    public final List<QuicPacket> getSentQuicPackets() {
        if (this.layerStackSendResult == null) {
            return null;
        }
        return ActionHelperUtil.getDataContainersForLayer(ImplementedLayers.QUICPACKET, this.layerStackSendResult).stream().map(container -> (QuicPacket)container).collect(Collectors.toList());
    }

    @Override
    public final List<Record> getSentRecords() {
        if (this.layerStackSendResult == null) {
            return null;
        }
        return ActionHelperUtil.getDataContainersForLayer(ImplementedLayers.RECORD, this.layerStackSendResult).stream().map(container -> (Record)container).collect(Collectors.toList());
    }

    @Override
    public final List<TcpStreamContainer> getSentTcpStreamContainers() {
        if (this.layerStackSendResult == null) {
            return null;
        }
        return ActionHelperUtil.getDataContainersForLayer(ImplementedLayers.TCP, this.layerStackSendResult).stream().map(container -> (TcpStreamContainer)container).collect(Collectors.toList());
    }

    @Override
    public final List<UdpDataPacket> getSentUdpDataPackets() {
        if (this.layerStackSendResult == null) {
            return null;
        }
        return ActionHelperUtil.getDataContainersForLayer(ImplementedLayers.UDP, this.layerStackSendResult).stream().map(container -> (UdpDataPacket)container).collect(Collectors.toList());
    }

    @Override
    public List<TcpStreamContainer> getReceivedTcpStreamContainers() {
        if (this.layerStackReceiveResult == null) {
            return null;
        }
        return ActionHelperUtil.getDataContainersForLayer(ImplementedLayers.TCP, this.layerStackReceiveResult).stream().map(container -> (TcpStreamContainer)container).collect(Collectors.toList());
    }

    @Override
    public List<UdpDataPacket> getReceivedUdpDataPackets() {
        if (this.layerStackReceiveResult == null) {
            return null;
        }
        return ActionHelperUtil.getDataContainersForLayer(ImplementedLayers.UDP, this.layerStackReceiveResult).stream().map(container -> (UdpDataPacket)container).collect(Collectors.toList());
    }
}

