/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow.action;

import de.rub.nds.tlsattacker.core.constants.ExtensionType;
import de.rub.nds.tlsattacker.core.exceptions.ActionExecutionException;
import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.workflow.action.ConnectionBoundAction;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.EnumSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@XmlRootElement(name="ChangeProposedExtensions")
public class ChangeProposedExtensionsAction
extends ConnectionBoundAction {
    private static final Logger LOGGER = LogManager.getLogger();
    private EnumSet<ExtensionType> newList = null;
    private EnumSet<ExtensionType> oldList = null;
    private boolean replace;

    public ChangeProposedExtensionsAction(EnumSet<ExtensionType> newList) {
        this.newList = newList;
    }

    public ChangeProposedExtensionsAction() {
    }

    public EnumSet<ExtensionType> getNewList() {
        return this.newList;
    }

    public void setNewList(EnumSet<ExtensionType> newList) {
        this.newList = newList;
    }

    public EnumSet<ExtensionType> getOldList() {
        return this.oldList;
    }

    @Override
    public void execute(State state) throws ActionExecutionException {
        TlsContext tlsContext = state.getContext(this.getConnectionAlias()).getTlsContext();
        if (this.isExecuted()) {
            throw new ActionExecutionException("Action already executed!");
        }
        this.oldList = tlsContext.getProposedExtensions();
        tlsContext.getProposedExtensions().clear();
        tlsContext.getProposedExtensions().addAll(this.newList);
        LOGGER.info("Changed proposed extension set from {} to {}", this.oldList, this.newList);
        this.setExecuted(true);
    }

    @Override
    public void reset() {
        this.setExecuted(null);
    }

    @Override
    public boolean executedAsPlanned() {
        return this.isExecuted();
    }
}

