/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow.action;

import de.rub.nds.tlsattacker.core.exceptions.ActionExecutionException;
import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.workflow.action.ConnectionBoundAction;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@XmlSeeAlso(value={TlsContext.class})
@XmlRootElement(name="ChangeContextValue")
public class ChangeContextValueAction<T>
extends ConnectionBoundAction {
    private static final Logger LOGGER = LogManager.getLogger();
    private T newValue;
    @XmlElementWrapper(name="newValueList")
    @XmlElement(name="newValue")
    private List<T> newValueList;
    private T oldValue;
    private List<T> oldValueList;
    private String fieldName;
    @XmlElement
    private Boolean usesList = null;

    public ChangeContextValueAction(String fieldName, T newValue) {
        this.newValue = newValue;
        this.fieldName = fieldName;
    }

    public ChangeContextValueAction(String fieldName, List<T> newValueList) {
        this.usesList = true;
        this.newValueList = newValueList;
        this.fieldName = fieldName;
    }

    @SafeVarargs
    public ChangeContextValueAction(String fieldName, T ... newValueList) {
        this(fieldName, Arrays.asList(newValueList));
    }

    public ChangeContextValueAction() {
    }

    @Override
    public void execute(State state) throws ActionExecutionException {
        TlsContext tlsContext = state.getContext(this.getConnectionAlias()).getTlsContext();
        if (this.isExecuted()) {
            throw new ActionExecutionException("Action already executed!");
        }
        try {
            Field field = tlsContext.getClass().getDeclaredField(this.fieldName);
            field.setAccessible(true);
            if (!this.isUsesList()) {
                this.oldValue = field.get(tlsContext);
                field.set(tlsContext, this.newValue);
                LOGGER.info(String.format("Changed %s from %s to %s", this.fieldName, this.oldValue == null ? "null" : this.oldValue.toString(), this.newValue.toString()));
            } else {
                this.oldValueList = (List)field.get(tlsContext);
                field.set(tlsContext, this.newValueList);
                LOGGER.info(String.format("Changed %s from %s to %s", this.fieldName, this.oldValueList == null ? "null" : this.oldValueList.toString(), this.newValueList.toString()));
            }
            this.setExecuted(true);
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
            throw new ActionExecutionException("Action could not be executed");
        }
    }

    @Override
    public void reset() {
        this.oldValue = null;
        this.setExecuted(null);
    }

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 83 * hash + Objects.hashCode(this.newValue);
        hash = 83 * hash + Objects.hashCode(this.oldValue);
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChangeContextValueAction other = (ChangeContextValueAction)obj;
        if (!Objects.equals(this.fieldName, other.getFieldName())) {
            return false;
        }
        if (!this.isUsesList() && this.getNewValue() != null && this.getNewValue().getClass().isArray()) {
            int i;
            int length2;
            int length;
            if (this.newValue != null && other.newValue != null) {
                length = Array.getLength(this.newValue);
                if (length != (length2 = Array.getLength(other.newValue))) {
                    return false;
                }
                for (i = 0; i < length; ++i) {
                    if (Array.get(this.newValue, i).equals(Array.get(other.newValue, i))) continue;
                    return false;
                }
            }
            if (this.oldValue != null && other.oldValue != null) {
                length = Array.getLength(this.oldValue);
                if (length != (length2 = Array.getLength(other.oldValue))) {
                    return false;
                }
                for (i = 0; i < length; ++i) {
                    if (Array.get(this.oldValue, i).equals(Array.get(other.oldValue, i))) continue;
                    return false;
                }
            }
            if (this.oldValue == null && other.oldValue != null) {
                return false;
            }
            return this.newValue != null || other.newValue == null;
        }
        if (!this.isUsesList()) {
            return Objects.equals(this.oldValue, other.oldValue) && Objects.equals(this.newValue, other.newValue);
        }
        return this.newValueList.equals(other.newValueList) && (this.oldValueList == other.oldValueList || this.oldValueList.equals(other.oldValueList));
    }

    @Override
    public boolean executedAsPlanned() {
        return this.isExecuted();
    }

    private boolean isUsesList() {
        if (this.usesList != null) {
            return this.usesList;
        }
        return false;
    }

    public void setNewValue(T newValue) {
        if (this.isUsesList()) {
            throw new UnsupportedOperationException("The action was initialized with a list");
        }
        this.newValue = newValue;
    }

    public void setNewValue(List<T> newValue) {
        if (!this.isUsesList()) {
            throw new UnsupportedOperationException("The action was not initialized with a list");
        }
        this.newValueList = newValue;
    }

    @SafeVarargs
    public final void setNewValue(T ... newValue) {
        this.setNewValue(Arrays.asList(newValue));
    }

    public final T getNewValue() {
        if (this.isUsesList()) {
            throw new UnsupportedOperationException("The action was initialized with a list");
        }
        return this.newValue;
    }

    public List<T> getNewValueList() {
        if (!this.isUsesList()) {
            throw new UnsupportedOperationException("The action was not initialized with a list");
        }
        return this.newValueList;
    }

    public T getOldValue() {
        if (this.isUsesList()) {
            throw new UnsupportedOperationException("The action was initialized with a list");
        }
        return this.oldValue;
    }

    public List<T> getOldValueList() {
        if (!this.isUsesList()) {
            throw new UnsupportedOperationException("The action was not initialized with a list");
        }
        return this.oldValueList;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }
}

