/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow.action;

import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.protocol.ProtocolMessage;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.workflow.action.ReceiveTillAction;
import jakarta.xml.bind.annotation.XmlRootElement;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@XmlRootElement(name="BufferedReceiveTill")
public class BufferedReceiveTillAction
extends ReceiveTillAction {
    private static final Logger LOGGER = LogManager.getLogger();

    public BufferedReceiveTillAction() {
    }

    public BufferedReceiveTillAction(String connectionAlias, ProtocolMessage waitTillMessage) {
        super(connectionAlias, waitTillMessage);
    }

    @Override
    public void execute(State state) {
        super.execute(state);
        TlsContext tlsContext = state.getContext(this.getConnectionAlias()).getTlsContext();
        tlsContext.getMessageBuffer().addAll(this.getReceivedMessages());
        tlsContext.getRecordBuffer().addAll(this.getReceivedRecords());
        LOGGER.debug("New message buffer size: {}", (Object)tlsContext.getMessageBuffer().size());
        LOGGER.debug("New record buffer size: {}", (Object)tlsContext.getRecordBuffer().size());
    }
}

