/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow.action;

import de.rub.nds.tlsattacker.core.exceptions.ActionExecutionException;
import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.layer.data.Handler;
import de.rub.nds.tlsattacker.core.protocol.ProtocolMessage;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.workflow.action.ConnectionBoundAction;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.LinkedList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@XmlRootElement(name="ApplyBufferedMessages")
public class ApplyBufferedMessagesAction
extends ConnectionBoundAction {
    private static final Logger LOGGER = LogManager.getLogger();

    public ApplyBufferedMessagesAction() {
    }

    public ApplyBufferedMessagesAction(String connectionAlias) {
        super(connectionAlias);
    }

    @Override
    public void execute(State state) throws ActionExecutionException {
        TlsContext ctx = state.getContext(this.connectionAlias).getTlsContext();
        if (this.isExecuted()) {
            throw new ActionExecutionException("Action already executed!");
        }
        LinkedList<ProtocolMessage> messages = ctx.getMessageBuffer();
        if (messages.isEmpty()) {
            LOGGER.debug("Empty buffer, no messages to apply");
        } else {
            for (ProtocolMessage msg : messages) {
                LOGGER.debug("Applying buffered {} to context {}", (Object)msg.toCompactString(), (Object)ctx);
                Handler h = msg.getHandler(ctx.getContext());
                h.adjustContext(msg);
            }
        }
        this.setExecuted(true);
    }

    @Override
    public boolean executedAsPlanned() {
        return this.isExecuted();
    }

    @Override
    public void reset() {
        this.setExecuted(false);
    }
}

