/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow;

import de.rub.nds.protocol.exception.ConfigurationException;
import de.rub.nds.protocol.exception.PreparationException;
import de.rub.nds.protocol.exception.SkipActionException;
import de.rub.nds.protocol.exception.TransportHandlerConnectException;
import de.rub.nds.protocol.exception.WorkflowExecutionException;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.constants.AlertDescription;
import de.rub.nds.tlsattacker.core.constants.AlertLevel;
import de.rub.nds.tlsattacker.core.constants.ProtocolMessageType;
import de.rub.nds.tlsattacker.core.exceptions.ActionExecutionException;
import de.rub.nds.tlsattacker.core.layer.LayerStackFactory;
import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.protocol.ProtocolMessage;
import de.rub.nds.tlsattacker.core.protocol.message.AlertMessage;
import de.rub.nds.tlsattacker.core.state.Context;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.workflow.BouncyCastleProviderChecker;
import de.rub.nds.tlsattacker.core.workflow.WorkflowTraceResultUtil;
import de.rub.nds.tlsattacker.core.workflow.action.SendAction;
import de.rub.nds.tlsattacker.core.workflow.action.TlsAction;
import de.rub.nds.tlsattacker.core.workflow.action.executor.ActionOption;
import de.rub.nds.tlsattacker.core.workflow.action.executor.WorkflowExecutorType;
import de.rub.nds.tlsattacker.transport.Connection;
import de.rub.nds.tlsattacker.transport.TransportHandler;
import de.rub.nds.tlsattacker.transport.TransportHandlerFactory;
import de.rub.nds.tlsattacker.transport.socket.SocketState;
import de.rub.nds.tlsattacker.transport.tcp.ClientTcpTransportHandler;
import de.rub.nds.tlsattacker.transport.tcp.TcpTransportHandler;
import java.io.IOException;
import java.security.Provider;
import java.security.Security;
import java.util.List;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public abstract class WorkflowExecutor {
    private static final Logger LOGGER = LogManager.getLogger();
    private Function<State, Integer> beforeTransportPreInitCallback = null;
    private Function<State, Integer> beforeTransportInitCallback = null;
    private Function<State, Integer> afterTransportInitCallback = null;
    private Function<State, Integer> afterExecutionCallback = null;
    protected final WorkflowExecutorType type;
    protected final State state;
    protected final Config config;

    public WorkflowExecutor(WorkflowExecutorType type, State state) {
        this.type = type;
        this.state = state;
        this.config = state.getConfig();
    }

    public abstract void executeWorkflow();

    public void initProtocolStack(Context context) throws IOException {
        context.setLayerStack(LayerStackFactory.createLayerStack(this.config.getDefaultLayerConfiguration(), context));
    }

    public void initTransportHandler(State state) {
        for (Context context : state.getAllContexts()) {
            if (context.getTransportHandler() != null) continue;
            if (context.getConnection() == null) {
                throw new ConfigurationException("Connection end not set");
            }
            context.setTransportHandler(TransportHandlerFactory.createTransportHandler((Connection)context.getConnection()));
            context.getTransportHandler().setResetClientSourcePort(this.config.isResetClientSourcePort().booleanValue());
            if (!(context.getTransportHandler() instanceof ClientTcpTransportHandler)) continue;
            ((ClientTcpTransportHandler)context.getTransportHandler()).setRetryFailedSocketInitialization(this.config.isRetryFailedClientTcpSocketInitialization().booleanValue());
        }
        try {
            if (this.getBeforeTransportPreInitCallback() != null) {
                LOGGER.debug("Executing beforeTransportPreInitCallback");
                this.getBeforeTransportPreInitCallback().apply(state);
            }
            LOGGER.debug("Starting pre-initalization of TransportHandler");
            for (Context context : state.getAllContexts()) {
                context.getTransportHandler().preInitialize();
            }
            LOGGER.debug("Finished pre-initalization of TransportHandler");
            if (this.getBeforeTransportInitCallback() != null) {
                LOGGER.debug("Executing beforeTransportInitCallback");
                this.getBeforeTransportInitCallback().apply(state);
            }
            LOGGER.debug("Starting initalization of TransportHandler");
            for (Context context : state.getAllContexts()) {
                context.getTransportHandler().initialize();
            }
            if (this.getAfterTransportInitCallback() != null) {
                LOGGER.debug("Executing afterTransportInitCallback");
                this.getAfterTransportInitCallback().apply(state);
            }
            LOGGER.debug("Finished initalization of TransportHandler");
        }
        catch (Exception ex) {
            throw new TransportHandlerConnectException("Unable to initialize the transport handler", (Throwable)ex);
        }
    }

    protected void executeAction(TlsAction action, State state) throws SkipActionException {
        try {
            action.execute(state);
        }
        catch (WorkflowExecutionException ex) {
            LOGGER.error("Fatal error during action execution, stopping execution: ", (Throwable)ex);
            state.setExecutionException(ex);
            throw ex;
        }
        catch (PreparationException | ActionExecutionException | UnsupportedOperationException ex) {
            state.setExecutionException(ex);
            LOGGER.warn("Not fatal error during action execution, skipping action: {}", (Object)action, (Object)ex);
            throw new SkipActionException(ex);
        }
        catch (Exception ex) {
            LOGGER.error("Unexpected fatal error during action execution, stopping execution", (Throwable)ex);
            state.setExecutionException(ex);
            throw new WorkflowExecutionException((Throwable)ex);
        }
        finally {
            state.setEndTimestamp(System.currentTimeMillis());
        }
    }

    public Function<State, Integer> getBeforeTransportPreInitCallback() {
        return this.beforeTransportPreInitCallback;
    }

    public void setBeforeTransportPreInitCallback(Function<State, Integer> beforeTransportPreInitCallback) {
        this.beforeTransportPreInitCallback = beforeTransportPreInitCallback;
    }

    public Function<State, Integer> getBeforeTransportInitCallback() {
        return this.beforeTransportInitCallback;
    }

    public void setBeforeTransportInitCallback(Function<State, Integer> beforeTransportInitCallback) {
        this.beforeTransportInitCallback = beforeTransportInitCallback;
    }

    public Function<State, Integer> getAfterTransportInitCallback() {
        return this.afterTransportInitCallback;
    }

    public void setAfterTransportInitCallback(Function<State, Integer> afterTransportInitCallback) {
        this.afterTransportInitCallback = afterTransportInitCallback;
    }

    public Function<State, Integer> getAfterExecutionCallback() {
        return this.afterExecutionCallback;
    }

    public void setAfterExecutionCallback(Function<State, Integer> afterExecutionCallback) {
        this.afterExecutionCallback = afterExecutionCallback;
    }

    public void closeConnection() {
        for (Context context : this.state.getAllContexts()) {
            try {
                context.getTransportHandler().closeConnection();
            }
            catch (IOException ex) {
                LOGGER.warn("Could not close connection for context: {}", (Object)context.getConnection().getAlias());
                LOGGER.debug((Object)ex);
            }
        }
    }

    public void initAllLayer() throws IOException {
        this.initTransportHandler(this.state);
        for (Context ctx : this.state.getAllContexts()) {
            this.initProtocolStack(ctx);
        }
    }

    public void sendCloseNotify(TlsContext context) {
        AlertMessage alertMessage = new AlertMessage();
        alertMessage.setConfig(AlertLevel.FATAL, AlertDescription.CLOSE_NOTIFY);
        alertMessage.setLevel(AlertLevel.FATAL.getValue());
        SendAction sendAction = new SendAction(context.getConnection().getAlias(), alertMessage);
        sendAction.addActionOption(ActionOption.MAY_FAIL);
        sendAction.execute(this.state);
    }

    public void setFinalSocketState() {
        for (Context ctx : this.state.getAllContexts()) {
            TransportHandler handler = ctx.getTransportHandler();
            if (handler instanceof TcpTransportHandler) {
                SocketState socketSt = ((TcpTransportHandler)handler).getSocketState(this.config.isReceiveFinalTcpSocketStateWithTimeout().booleanValue());
                ctx.getTcpContext().setFinalSocketState(socketSt);
                continue;
            }
            ctx.getTcpContext().setFinalSocketState(SocketState.UNAVAILABLE);
        }
    }

    public boolean isReceivedFatalAlert() {
        for (Context ctx : this.state.getAllContexts()) {
            if (!ctx.getTlsContext().isReceivedFatalAlert()) continue;
            return true;
        }
        return false;
    }

    public boolean isReceivedWarningAlert() {
        List<ProtocolMessage> allReceivedMessages = WorkflowTraceResultUtil.getAllReceivedMessagesOfType(this.state.getWorkflowTrace(), ProtocolMessageType.ALERT);
        for (ProtocolMessage message : allReceivedMessages) {
            AlertMessage alert = (AlertMessage)message;
            if (((Byte)alert.getLevel().getValue()).byteValue() != AlertLevel.WARNING.getValue()) continue;
            return true;
        }
        return false;
    }

    public boolean isIoException() {
        for (Context context : this.state.getAllContexts()) {
            if (!context.getTlsContext().isReceivedTransportHandlerException()) continue;
            return true;
        }
        return false;
    }

    static {
        if (!BouncyCastleProviderChecker.isLoaded()) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

