/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.util;

import de.rub.nds.protocol.exception.ConfigurationException;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.CertificateEncodingException;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.tls.crypto.TlsCertificate;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCertificate;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;

public class JKSLoader {
    public static Certificate loadCertificate(KeyStore keyStore, String alias) {
        try {
            if (alias == null || keyStore == null) {
                throw new ConfigurationException("The certificate cannot be fetched. Have you provided correct certificate alias and key? (Current alias: " + alias + ")");
            }
            java.security.cert.Certificate sunCert = keyStore.getCertificate(alias);
            if (sunCert == null) {
                throw new ConfigurationException("The certificate cannot be fetched. Have you provided correct certificate alias and key? (Current alias: " + alias + ")");
            }
            byte[] certBytes = sunCert.getEncoded();
            return BcTlsCertificate.parseCertificate((byte[])certBytes);
        }
        catch (IOException | KeyStoreException | CertificateEncodingException ex) {
            throw new ConfigurationException("The certificate cannot be fetched. Have you provided correct certificate alias and key? (Current alias: " + alias + ")");
        }
    }

    public static TlsCertificate loadTLSCertificate(KeyStore keyStore, String alias) {
        return new BcTlsCertificate(new BcTlsCrypto(), JKSLoader.loadCertificate(keyStore, alias));
    }

    private JKSLoader() {
    }
}

