/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.socket;

import de.rub.nds.protocol.util.SilentByteArrayOutputStream;
import de.rub.nds.tlsattacker.core.protocol.ProtocolMessage;
import de.rub.nds.tlsattacker.core.protocol.message.ApplicationMessage;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.workflow.action.SendAction;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EncapsulatingOutputStream
extends OutputStream {
    private static final Logger LOGGER = LogManager.getLogger();
    private final State state;
    private SilentByteArrayOutputStream outputStream = new SilentByteArrayOutputStream();

    public EncapsulatingOutputStream(State state) {
        this.state = state;
    }

    @Override
    public void write(int i) throws IOException {
        this.outputStream.write(i);
    }

    @Override
    public void flush() throws IOException {
        int actuallyRead;
        ApplicationMessage message = new ApplicationMessage();
        ByteArrayInputStream stream = new ByteArrayInputStream(this.outputStream.toByteArray());
        byte[] sendingBytes = new byte[16384];
        do {
            actuallyRead = 0;
            try {
                actuallyRead = stream.read(sendingBytes);
                if (actuallyRead <= 0) continue;
                message.setDataConfig(Arrays.copyOf(sendingBytes, actuallyRead));
                this.send(message);
            }
            catch (IOException ex) {
                LOGGER.warn((Object)ex);
            }
        } while (actuallyRead > 0);
        this.outputStream = new SilentByteArrayOutputStream();
    }

    private void send(ProtocolMessage message) {
        SendAction action = new SendAction(message);
        action.setConnectionAlias(this.state.getTlsContext().getConnection().getAlias());
        action.execute(this.state);
    }
}

