/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.record;

import de.rub.nds.modifiablevariable.ModifiableVariableFactory;
import de.rub.nds.modifiablevariable.ModifiableVariableHolder;
import de.rub.nds.modifiablevariable.ModifiableVariableProperty;
import de.rub.nds.modifiablevariable.biginteger.ModifiableBigInteger;
import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.modifiablevariable.integer.ModifiableInteger;
import de.rub.nds.modifiablevariable.singlebyte.ModifiableByte;
import de.rub.nds.modifiablevariable.util.DataConverter;
import de.rub.nds.modifiablevariable.util.SuppressingTrueBooleanAdapter;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.constants.ProtocolMessageType;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.layer.data.DataContainer;
import de.rub.nds.tlsattacker.core.layer.data.Handler;
import de.rub.nds.tlsattacker.core.record.RecordCryptoComputations;
import de.rub.nds.tlsattacker.core.record.compressor.RecordCompressor;
import de.rub.nds.tlsattacker.core.record.crypto.Encryptor;
import de.rub.nds.tlsattacker.core.record.handler.RecordHandler;
import de.rub.nds.tlsattacker.core.record.parser.RecordParser;
import de.rub.nds.tlsattacker.core.record.preparator.RecordPreparator;
import de.rub.nds.tlsattacker.core.record.serializer.RecordSerializer;
import de.rub.nds.tlsattacker.core.state.Context;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.List;
import java.util.Objects;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Record
extends ModifiableVariableHolder
implements DataContainer {
    @XmlTransient
    protected boolean shouldPrepareDefault = true;
    private Integer maxRecordLengthConfig;
    @ModifiableVariableProperty
    private ModifiableByteArray completeRecordBytes;
    @ModifiableVariableProperty
    private ModifiableByteArray protocolMessageBytes;
    @ModifiableVariableProperty
    private ModifiableByteArray cleanProtocolMessageBytes;
    private ProtocolMessageType contentMessageType;
    @ModifiableVariableProperty
    private ModifiableByte contentType;
    @ModifiableVariableProperty
    private ModifiableByteArray protocolVersion;
    @ModifiableVariableProperty(purpose=ModifiableVariableProperty.Purpose.LENGTH)
    private ModifiableInteger length;
    @ModifiableVariableProperty
    private ModifiableInteger epoch;
    @ModifiableVariableProperty
    private ModifiableBigInteger sequenceNumber;
    @ModifiableVariableProperty
    private ModifiableByteArray encryptedSequenceNumber;
    @ModifiableVariableProperty
    private ModifiableByteArray connectionId;
    @ModifiableVariableProperty
    private ModifiableByte unifiedHeader;
    private RecordCryptoComputations computations;
    @XmlJavaTypeAdapter(value=SuppressingTrueBooleanAdapter.class)
    private Boolean shouldPrepare = null;

    public Record(Config config) {
        this.maxRecordLengthConfig = config.getDefaultMaxRecordData();
    }

    public Record() {
    }

    public Record(Integer maxRecordLengthConfig) {
        this.maxRecordLengthConfig = maxRecordLengthConfig;
    }

    @Override
    public boolean shouldPrepare() {
        return this.shouldPrepareDefault;
    }

    public void setShouldPrepare(boolean shouldPrepare) {
        this.shouldPrepareDefault = shouldPrepare;
    }

    public ModifiableInteger getLength() {
        return this.length;
    }

    public ModifiableByte getContentType() {
        return this.contentType;
    }

    public ModifiableByteArray getProtocolVersion() {
        return this.protocolVersion;
    }

    public void setLength(ModifiableInteger length) {
        this.length = length;
    }

    public void setLength(int length) {
        this.length = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.length, (Integer)length);
    }

    public void setContentType(ModifiableByte contentType) {
        this.contentType = contentType;
    }

    public void setContentType(byte contentType) {
        this.contentType = ModifiableVariableFactory.safelySetValue((ModifiableByte)this.contentType, (Byte)contentType);
    }

    public void setProtocolVersion(ModifiableByteArray protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    public void setProtocolVersion(byte[] array) {
        this.protocolVersion = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.protocolVersion, (byte[])array);
    }

    public ModifiableInteger getEpoch() {
        return this.epoch;
    }

    public void setEpoch(ModifiableInteger epoch) {
        this.epoch = epoch;
    }

    public void setEpoch(Integer epoch) {
        this.epoch = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.epoch, (Integer)epoch);
    }

    public ModifiableBigInteger getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void setSequenceNumber(ModifiableBigInteger sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    public void setSequenceNumber(BigInteger sequenceNumber) {
        this.sequenceNumber = ModifiableVariableFactory.safelySetValue((ModifiableBigInteger)this.sequenceNumber, (BigInteger)sequenceNumber);
    }

    public ModifiableByteArray getEncryptedSequenceNumber() {
        return this.encryptedSequenceNumber;
    }

    public void setEncryptedSequenceNumber(ModifiableByteArray encryptedSequenceNumber) {
        this.encryptedSequenceNumber = encryptedSequenceNumber;
    }

    public void setEncryptedSequenceNumber(byte[] encryptedSequenceNumber) {
        this.encryptedSequenceNumber = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.encryptedSequenceNumber, (byte[])encryptedSequenceNumber);
    }

    public ModifiableByteArray getConnectionId() {
        return this.connectionId;
    }

    public void setConnectionId(byte[] connectionId) {
        this.connectionId = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.connectionId, (byte[])connectionId);
    }

    public void setConnectionId(ModifiableByteArray connectionId) {
        this.connectionId = connectionId;
    }

    public RecordPreparator getRecordPreparator(TlsContext tlsContext, Encryptor encryptor, RecordCompressor compressor, ProtocolMessageType type) {
        return new RecordPreparator(tlsContext, this, encryptor, type, compressor);
    }

    public RecordParser getRecordParser(InputStream stream, ProtocolVersion version, TlsContext tlsContext) {
        return new RecordParser(stream, version, tlsContext);
    }

    public RecordSerializer getRecordSerializer() {
        return new RecordSerializer(this);
    }

    public ProtocolMessageType getContentMessageType() {
        return this.contentMessageType;
    }

    public void setContentMessageType(ProtocolMessageType contentMessageType) {
        this.contentMessageType = contentMessageType;
    }

    public ModifiableByteArray getCleanProtocolMessageBytes() {
        return this.cleanProtocolMessageBytes;
    }

    public void setCleanProtocolMessageBytes(byte[] cleanProtocolMessageBytes) {
        this.cleanProtocolMessageBytes = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.cleanProtocolMessageBytes, (byte[])cleanProtocolMessageBytes);
    }

    public void setCleanProtocolMessageBytes(ModifiableByteArray cleanProtocolMessageBytes) {
        this.cleanProtocolMessageBytes = cleanProtocolMessageBytes;
    }

    public ModifiableByteArray getProtocolMessageBytes() {
        return this.protocolMessageBytes;
    }

    public void setProtocolMessageBytes(ModifiableByteArray protocolMessageBytes) {
        this.protocolMessageBytes = protocolMessageBytes;
    }

    public void setProtocolMessageBytes(byte[] bytes) {
        this.protocolMessageBytes = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.protocolMessageBytes, (byte[])bytes);
    }

    public Integer getMaxRecordLengthConfig() {
        return this.maxRecordLengthConfig;
    }

    public void setMaxRecordLengthConfig(Integer maxRecordLengthConfig) {
        this.maxRecordLengthConfig = maxRecordLengthConfig;
    }

    public ModifiableByte getUnifiedHeader() {
        return this.unifiedHeader;
    }

    public void setUnifiedHeader(byte unifiedHeader) {
        this.unifiedHeader = ModifiableVariableFactory.safelySetValue((ModifiableByte)this.unifiedHeader, (Byte)unifiedHeader);
    }

    public void setUnifiedHeader(ModifiableByte unifiedHeader) {
        this.unifiedHeader = unifiedHeader;
    }

    public boolean isUnifiedHeaderCidPresent() {
        return ((Byte)this.unifiedHeader.getValue() & 0x10) != 0;
    }

    public boolean isUnifiedHeaderSqnLong() {
        return ((Byte)this.unifiedHeader.getValue() & 8) != 0;
    }

    public boolean isUnifiedHeaderLengthPresent() {
        return ((Byte)this.unifiedHeader.getValue() & 4) != 0;
    }

    public ModifiableByteArray getCompleteRecordBytes() {
        return this.completeRecordBytes;
    }

    public void setCompleteRecordBytes(ModifiableByteArray completeRecordBytes) {
        this.completeRecordBytes = completeRecordBytes;
    }

    public void setCompleteRecordBytes(byte[] completeRecordBytes) {
        this.completeRecordBytes = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.completeRecordBytes, (byte[])completeRecordBytes);
    }

    public RecordCryptoComputations getComputations() {
        return this.computations;
    }

    public void setComputations(RecordCryptoComputations computations) {
        this.computations = computations;
    }

    public void prepareComputations() {
        if (this.computations == null) {
            this.computations = new RecordCryptoComputations();
        }
    }

    public String toString() {
        ProtocolVersion version;
        ProtocolMessageType type;
        String contentTypeString = this.contentType == null || this.contentType.getOriginalValue() == null ? "null" : ((type = ProtocolMessageType.getContentType((Byte)this.contentType.getValue())) == null ? "UNKNOWN" : type.name());
        String protocolVersionString = this.protocolVersion == null || this.protocolVersion.getOriginalValue() == null ? "null" : ((version = ProtocolVersion.getProtocolVersion((byte[])this.protocolVersion.getValue())) == null ? "UNKNOWN" : version.name());
        String lengthString = this.length == null || this.length.getOriginalValue() == null ? "null" : ((Integer)this.length.getValue()).toString();
        return "Record[" + contentTypeString + ", " + protocolVersionString + ", " + lengthString + "]";
    }

    @Override
    public String toCompactString() {
        String stringContentType = "unspecified";
        String stringProtocolVersion = "unspecified";
        String stringLength = "unspecified";
        if (this.contentType != null && this.contentType.getValue() != null) {
            stringContentType = ((Byte)this.contentType.getValue()).toString();
        }
        if (this.protocolVersion != null && this.protocolVersion.getValue() != null) {
            stringContentType = DataConverter.bytesToHexString((byte[])((byte[])this.protocolVersion.getValue()));
        }
        if (this.length != null && this.length.getValue() != null) {
            stringLength = ((Integer)this.length.getValue()).toString();
        } else if (this.maxRecordLengthConfig != null) {
            stringLength = this.maxRecordLengthConfig.toString();
        }
        return "Record{contentType=" + stringContentType + ", protocolVersion=" + stringProtocolVersion + ", length=" + stringLength + "}";
    }

    public int hashCode() {
        int hash = 7;
        hash = 29 * hash + Objects.hashCode(this.contentType);
        hash = 29 * hash + Objects.hashCode(this.protocolVersion);
        hash = 29 * hash + Objects.hashCode(this.length);
        hash = 29 * hash + Objects.hashCode(this.epoch);
        hash = 29 * hash + Objects.hashCode(this.sequenceNumber);
        hash = 29 * hash + Objects.hashCode(this.encryptedSequenceNumber);
        hash = 29 * hash + Objects.hashCode(this.connectionId);
        hash = 29 * hash + Objects.hashCode((Object)this.computations);
        hash = 29 * hash + Objects.hashCode(this.unifiedHeader);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Record other = (Record)obj;
        if (!Objects.equals(this.contentType, other.contentType)) {
            return false;
        }
        if (!Objects.equals(this.protocolVersion, other.protocolVersion)) {
            return false;
        }
        if (!Objects.equals(this.length, other.length)) {
            return false;
        }
        if (!Objects.equals(this.epoch, other.epoch)) {
            return false;
        }
        if (!Objects.equals(this.sequenceNumber, other.sequenceNumber)) {
            return false;
        }
        if (!Objects.equals(this.encryptedSequenceNumber, other.encryptedSequenceNumber)) {
            return false;
        }
        if (!Objects.equals(this.connectionId, other.connectionId)) {
            return false;
        }
        if (!Objects.equals((Object)this.computations, (Object)other.computations)) {
            return false;
        }
        return Objects.equals(this.unifiedHeader, other.unifiedHeader);
    }

    public List<ModifiableVariableHolder> getAllModifiableVariableHolders() {
        List holders = super.getAllModifiableVariableHolders();
        if (this.computations != null) {
            holders.add(this.computations);
        }
        return holders;
    }

    public void reset() {
        super.reset();
        this.setContentMessageType(null);
    }

    public RecordParser getParser(Context context, InputStream stream) {
        return new RecordParser(stream, context.getTlsContext().getLastRecordVersion(), context.getTlsContext());
    }

    public RecordPreparator getPreparator(Context context) {
        return new RecordPreparator(context.getTlsContext(), this, null, this.contentMessageType, null);
    }

    public RecordSerializer getSerializer(Context context) {
        return new RecordSerializer(this);
    }

    public Handler<Record> getHandler(Context context) {
        return new RecordHandler(context.getTlsContext());
    }
}

