/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.quic.serializer.frame;

import de.rub.nds.tlsattacker.core.quic.frame.StreamFrame;
import de.rub.nds.tlsattacker.core.quic.serializer.frame.QuicFrameSerializer;
import de.rub.nds.tlsattacker.core.quic.util.VariableLengthIntegerEncoding;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StreamFrameSerializer
extends QuicFrameSerializer<StreamFrame> {
    private static final Logger LOGGER = LogManager.getLogger();

    public StreamFrameSerializer(StreamFrame frame) {
        super(frame);
    }

    @Override
    protected byte[] serializeBytes() {
        this.writeFrameType();
        this.writeStreamId();
        if (((StreamFrame)this.frame).getOffset() != null) {
            this.writeOffset();
        }
        if (((StreamFrame)this.frame).getLength() != null) {
            this.writeLength();
        }
        this.writeData();
        return this.getAlreadySerialized();
    }

    protected void writeStreamId() {
        this.appendBytes(VariableLengthIntegerEncoding.encodeVariableLengthInteger(((Integer)((StreamFrame)this.frame).getStreamId().getValue()).intValue()));
        LOGGER.debug("Stream ID: {}", ((StreamFrame)this.frame).getStreamId().getValue());
    }

    protected void writeOffset() {
        this.appendBytes(VariableLengthIntegerEncoding.encodeVariableLengthInteger(((Integer)((StreamFrame)this.frame).getOffset().getValue()).intValue()));
        LOGGER.debug("Offset: {}", ((StreamFrame)this.frame).getOffset().getValue());
    }

    protected void writeLength() {
        this.appendBytes(VariableLengthIntegerEncoding.encodeVariableLengthInteger(((Integer)((StreamFrame)this.frame).getLength().getValue()).intValue()));
        LOGGER.debug("Length: {}", ((StreamFrame)this.frame).getLength().getValue());
    }

    protected void writeData() {
        this.appendBytes((byte[])((StreamFrame)this.frame).getData().getValue());
        LOGGER.debug("Data: {}", ((StreamFrame)this.frame).getData().getValue());
    }
}

