/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.quic.serializer.frame;

import de.rub.nds.tlsattacker.core.quic.frame.StreamDataBlockedFrame;
import de.rub.nds.tlsattacker.core.quic.serializer.frame.QuicFrameSerializer;
import de.rub.nds.tlsattacker.core.quic.util.VariableLengthIntegerEncoding;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StreamDataBlockedFrameSerializer
extends QuicFrameSerializer<StreamDataBlockedFrame> {
    private static final Logger LOGGER = LogManager.getLogger();

    public StreamDataBlockedFrameSerializer(StreamDataBlockedFrame frame) {
        super(frame);
    }

    @Override
    protected byte[] serializeBytes() {
        this.writeFrameType();
        this.writeStreamId();
        this.writeMaximumStreamData();
        return this.getAlreadySerialized();
    }

    private void writeStreamId() {
        this.appendBytes(VariableLengthIntegerEncoding.encodeVariableLengthInteger(((Integer)((StreamDataBlockedFrame)this.frame).getStreamId().getValue()).intValue()));
        LOGGER.debug("Stream ID: {}", ((StreamDataBlockedFrame)this.frame).getStreamId().getValue());
    }

    private void writeMaximumStreamData() {
        this.appendBytes(VariableLengthIntegerEncoding.encodeVariableLengthInteger(((Integer)((StreamDataBlockedFrame)this.frame).getMaximumStreamData().getValue()).intValue()));
        LOGGER.debug("Maximum Stream Data: {}", ((StreamDataBlockedFrame)this.frame).getMaximumStreamData().getValue());
    }
}

