/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.quic.preparator.frame;

import de.rub.nds.tlsattacker.core.quic.frame.StreamFrame;
import de.rub.nds.tlsattacker.core.quic.preparator.frame.QuicFramePreparator;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StreamFramePreparator
extends QuicFramePreparator<StreamFrame> {
    private static final Logger LOGGER = LogManager.getLogger();

    public StreamFramePreparator(Chooser chooser, StreamFrame frame) {
        super(chooser, frame);
    }

    @Override
    public void prepare() {
        LOGGER.debug("Preparing STREAM Frame");
        this.prepareData((StreamFrame)this.getObject());
        this.prepareLengthData((StreamFrame)this.getObject());
        this.prepareOffsetData((StreamFrame)this.getObject());
        this.prepareStreamId((StreamFrame)this.getObject());
        this.prepareFrameType((StreamFrame)this.getObject());
    }

    protected void prepareData(StreamFrame frame) {
        frame.setData(frame.getDataConfig());
        LOGGER.debug("Crypto Data: {}", frame.getData().getValue());
    }

    protected void prepareLengthData(StreamFrame frame) {
        frame.setLength(frame.getLengthConfig());
        LOGGER.debug("Length: {}", frame.getLength().getValue());
    }

    protected void prepareOffsetData(StreamFrame frame) {
        frame.setOffset(frame.getOffsetConfig());
        LOGGER.debug("Offset: {}", frame.getOffset().getValue());
    }

    protected void prepareStreamId(StreamFrame frame) {
        frame.setStreamId(frame.getStreamIdConfig());
        LOGGER.debug("Stream ID: {}", frame.getStreamId().getValue());
    }

    protected void prepareFrameType(StreamFrame frame) {
        byte quicFrameType = 8;
        if (frame.getOffset() != null) {
            quicFrameType = (byte)(quicFrameType | 4);
        }
        if (frame.getLength() != null) {
            quicFrameType = (byte)(quicFrameType | 2);
        }
        if (frame.isFinalFrameConfig()) {
            quicFrameType = (byte)(quicFrameType | 1);
        }
        frame.setFrameType(quicFrameType);
        LOGGER.debug("Frame Type: {}", frame.getData().getValue());
    }
}

