/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.quic.parser.frame;

import de.rub.nds.tlsattacker.core.quic.constants.QuicFrameType;
import de.rub.nds.tlsattacker.core.quic.frame.StreamFrame;
import de.rub.nds.tlsattacker.core.quic.parser.frame.QuicFrameParser;
import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StreamFrameParser
extends QuicFrameParser<StreamFrame> {
    private static final Logger LOGGER = LogManager.getLogger();

    public StreamFrameParser(InputStream stream) {
        super(stream);
    }

    @Override
    public void parse(StreamFrame frame) {
        this.parseStreamId(frame);
        QuicFrameType frameType = QuicFrameType.getFrameType((Byte)frame.getFrameType().getValue());
        if (frameType == QuicFrameType.STREAM_FRAME_OFF || frameType == QuicFrameType.STREAM_FRAME_OFF_FIN || frameType == QuicFrameType.STREAM_FRAME_OFF_LEN || frameType == QuicFrameType.STREAM_FRAME_OFF_LEN_FIN) {
            this.parseOffset(frame);
        } else {
            frame.setOffset(0);
        }
        if (frameType == QuicFrameType.STREAM_FRAME_LEN || frameType == QuicFrameType.STREAM_FRAME_OFF_LEN || frameType == QuicFrameType.STREAM_FRAME_LEN_FIN || frameType == QuicFrameType.STREAM_FRAME_OFF_LEN_FIN) {
            this.parseLength(frame);
        }
        this.parseData(frame, frameType);
    }

    protected void parseStreamId(StreamFrame frame) {
        frame.setStreamId((int)this.parseVariableLengthInteger());
        LOGGER.debug("Stream ID: {}", frame.getStreamId().getValue());
    }

    protected void parseOffset(StreamFrame frame) {
        frame.setOffset((int)this.parseVariableLengthInteger());
        LOGGER.debug("Offset: {}", frame.getOffset().getValue());
    }

    protected void parseLength(StreamFrame frame) {
        frame.setLength((int)this.parseVariableLengthInteger());
        LOGGER.debug("Length: {}", frame.getLength().getValue());
    }

    protected void parseData(StreamFrame frame, QuicFrameType frameType) {
        if (frameType == QuicFrameType.STREAM_FRAME || frameType == QuicFrameType.STREAM_FRAME_OFF || frameType == QuicFrameType.STREAM_FRAME_FIN) {
            frame.setData(this.parseTillEnd());
        } else {
            frame.setData(this.parseByteArrayField((Integer)frame.getLength().getValue()));
        }
        LOGGER.debug("Data: {}", frame.getData().getValue());
    }
}

