/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.quic.packet;

import de.rub.nds.modifiablevariable.ModifiableVariableFactory;
import de.rub.nds.modifiablevariable.ModifiableVariableProperty;
import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.tlsattacker.core.layer.data.Preparator;
import de.rub.nds.tlsattacker.core.layer.data.Serializer;
import de.rub.nds.tlsattacker.core.quic.constants.QuicPacketType;
import de.rub.nds.tlsattacker.core.quic.constants.QuicRetryConstants;
import de.rub.nds.tlsattacker.core.quic.constants.QuicVersion;
import de.rub.nds.tlsattacker.core.quic.handler.packet.RetryPacketHandler;
import de.rub.nds.tlsattacker.core.quic.packet.LongHeaderPacket;
import de.rub.nds.tlsattacker.core.quic.parser.packet.RetryPacketParser;
import de.rub.nds.tlsattacker.core.quic.preparator.packet.RetryPacketPreparator;
import de.rub.nds.tlsattacker.core.quic.serializer.packet.RetryPacketSerializer;
import de.rub.nds.tlsattacker.core.state.Context;
import de.rub.nds.tlsattacker.core.state.quic.QuicContext;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.AEADBadTagException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.util.Arrays;

@XmlRootElement
public class RetryPacket
extends LongHeaderPacket {
    private static final Logger LOGGER = LogManager.getLogger();
    @ModifiableVariableProperty
    protected ModifiableByteArray retryToken;
    @ModifiableVariableProperty
    protected ModifiableByteArray retryIntegrityTag;

    public RetryPacket() {
        super(QuicPacketType.RETRY_PACKET);
        this.setUnprotectedFlags((byte)-16);
    }

    public RetryPacket(byte flags) {
        super(QuicPacketType.RETRY_PACKET);
        this.setProtectedFlags(flags);
        this.setUnprotectedFlags(flags);
        this.protectedHeaderHelper.write((int)flags);
    }

    public boolean verifyRetryIntegrityTag(QuicContext context) {
        byte[] computedTag;
        byte[] pseudoPacket = ByteBuffer.allocate(1 + context.getFirstDestinationConnectionId().length + 1 + 4 + 1 + (Byte)this.getDestinationConnectionIdLength().getValue() + 1 + (Byte)this.getSourceConnectionIdLength().getValue() + ((byte[])this.retryToken.getValue()).length).put((byte)(context.getFirstDestinationConnectionId().length & 0xFF)).put(context.getFirstDestinationConnectionId()).put((Byte)this.getUnprotectedFlags().getValue()).put(context.getQuicVersion().getByteValue()).put((Byte)this.getDestinationConnectionIdLength().getValue()).put((byte[])this.getDestinationConnectionId().getValue()).put((Byte)this.getSourceConnectionIdLength().getValue()).put((byte[])this.getSourceConnectionId().getValue()).put((byte[])this.retryToken.getValue()).array();
        LOGGER.trace("Build Integrity Check Pseudo Packet {}", (Object)pseudoPacket);
        try {
            SecretKeySpec secretKey = new SecretKeySpec(context.getQuicVersion() == QuicVersion.VERSION_1 ? QuicRetryConstants.getQuic1RetryIntegrityTagKey() : QuicRetryConstants.getQuic2RetryIntegrityTagKey(), "AES");
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            GCMParameterSpec gcmParameterSpec = new GCMParameterSpec(128, context.getQuicVersion() == QuicVersion.VERSION_1 ? QuicRetryConstants.getQuic1RetryIntegrityTagIv() : QuicRetryConstants.getQuic2RetryIntegrityTagIv());
            cipher.init(1, (Key)secretKey, gcmParameterSpec);
            cipher.updateAAD(pseudoPacket);
            computedTag = cipher.doFinal();
        }
        catch (AEADBadTagException e) {
            LOGGER.debug("Retry Tag is invalid!");
            return false;
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            LOGGER.error("Error initializing Ciphers to verify Retry Integrity Tag!");
            LOGGER.trace((Object)e);
            return false;
        }
        if (computedTag.length == 0) {
            LOGGER.error("Attempted to compute Retry Integrity Tag for verification but result is empty!");
            return false;
        }
        boolean tagsEqual = Arrays.areEqual((byte[])((byte[])this.getRetryIntegrityTag().getValue()), (byte[])computedTag);
        LOGGER.debug("Retry Integrity Tag is valid? {}", (Object)tagsEqual);
        return tagsEqual;
    }

    public RetryPacketHandler getHandler(Context context) {
        return new RetryPacketHandler(context.getQuicContext());
    }

    public Serializer<RetryPacket> getSerializer(Context context) {
        return new RetryPacketSerializer(this);
    }

    public Preparator<RetryPacket> getPreparator(Context context) {
        return new RetryPacketPreparator(context.getChooser(), this);
    }

    public RetryPacketParser getParser(Context context, InputStream stream) {
        return new RetryPacketParser(stream, context.getQuicContext());
    }

    public ModifiableByteArray getRetryToken() {
        return this.retryToken;
    }

    public void setRetryToken(byte[] retryToken) {
        this.retryToken = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.retryToken, (byte[])retryToken);
    }

    public void setRetryToken(ModifiableByteArray retryToken) {
        this.retryToken = retryToken;
    }

    public ModifiableByteArray getRetryIntegrityTag() {
        return this.retryIntegrityTag;
    }

    public void setRetryIntegrityTag(byte[] retryIntegrityTag) {
        this.retryIntegrityTag = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.retryIntegrityTag, (byte[])retryIntegrityTag);
    }

    public void setRetryIntegrityTag(ModifiableByteArray retryIntegrityTag) {
        this.retryIntegrityTag = retryIntegrityTag;
    }
}

