/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.quic.handler.packet;

import de.rub.nds.tlsattacker.core.quic.handler.packet.LongHeaderPacketHandler;
import de.rub.nds.tlsattacker.core.quic.packet.VersionNegotiationPacket;
import de.rub.nds.tlsattacker.core.state.quic.QuicContext;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VersionNegotiationPacketHandler
extends LongHeaderPacketHandler<VersionNegotiationPacket> {
    private static final Logger LOGGER = LogManager.getLogger();

    public VersionNegotiationPacketHandler(QuicContext quicContext) {
        super(quicContext);
    }

    @Override
    public void adjustContext(VersionNegotiationPacket packet) {
        this.adjustSupportedVersions(packet);
    }

    private void adjustSupportedVersions(VersionNegotiationPacket packet) {
        List<byte[]> versionList = this.convertVersions((byte[])packet.getSupportedVersions().getValue());
        this.quicContext.setSupportedVersions(versionList);
        if (versionList != null) {
            LOGGER.debug("Set ServerSupportedQuicVersions in Context to {}", versionList);
        } else {
            LOGGER.debug("Set ClientSupportedCipherSuites in Context to null");
        }
    }

    private List<byte[]> convertVersions(byte[] bytesToConvert) {
        if (bytesToConvert.length % 4 != 0) {
            LOGGER.warn("Cannot convert: {} to a List<byte[]>", (Object)bytesToConvert);
            return null;
        }
        LinkedList<byte[]> list = new LinkedList<byte[]>();
        for (int i = 0; i < bytesToConvert.length; i += 4) {
            byte[] chunk = new byte[4];
            System.arraycopy(bytesToConvert, i, chunk, 0, 4);
            list.add(chunk);
        }
        return list;
    }
}

