/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.quic.handler.packet;

import de.rub.nds.protocol.exception.CryptoException;
import de.rub.nds.tlsattacker.core.quic.handler.packet.LongHeaderPacketHandler;
import de.rub.nds.tlsattacker.core.quic.packet.HandshakePacket;
import de.rub.nds.tlsattacker.core.quic.packet.QuicPacketCryptoComputations;
import de.rub.nds.tlsattacker.core.state.quic.QuicContext;
import java.security.NoSuchAlgorithmException;
import javax.crypto.NoSuchPaddingException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HandshakePacketHandler
extends LongHeaderPacketHandler<HandshakePacket> {
    private static final Logger LOGGER = LogManager.getLogger();

    public HandshakePacketHandler(QuicContext quicContext) {
        super(quicContext);
    }

    @Override
    public void adjustContext(HandshakePacket object) {
        try {
            if (!this.quicContext.isHandshakeSecretsInitialized()) {
                QuicPacketCryptoComputations.calculateHandshakeSecrets(this.quicContext.getContext());
            }
        }
        catch (CryptoException | NoSuchAlgorithmException | NoSuchPaddingException e) {
            LOGGER.error("Could not calculate handshake secrets", e);
        }
    }
}

