/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.quic.frame;

import de.rub.nds.modifiablevariable.ModifiableVariableFactory;
import de.rub.nds.modifiablevariable.ModifiableVariableProperty;
import de.rub.nds.modifiablevariable.integer.ModifiableInteger;
import de.rub.nds.tlsattacker.core.quic.constants.QuicFrameType;
import de.rub.nds.tlsattacker.core.quic.frame.QuicFrame;
import de.rub.nds.tlsattacker.core.quic.handler.frame.StreamDataBlockedFrameHandler;
import de.rub.nds.tlsattacker.core.quic.parser.frame.StreamDataBlockedFrameParser;
import de.rub.nds.tlsattacker.core.quic.preparator.frame.StreamDataBlockedFramePreparator;
import de.rub.nds.tlsattacker.core.quic.serializer.frame.StreamDataBlockedFrameSerializer;
import de.rub.nds.tlsattacker.core.state.Context;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.InputStream;

@XmlRootElement
public class StreamDataBlockedFrame
extends QuicFrame {
    @ModifiableVariableProperty
    protected ModifiableInteger streamId;
    @ModifiableVariableProperty
    protected ModifiableInteger maximumStreamData;
    private int streamIdConfig;
    private int maximumStreamDataConfig;

    public StreamDataBlockedFrame() {
        super(QuicFrameType.STREAM_DATA_BLOCKED_FRAME);
    }

    public StreamDataBlockedFrame(int streamIdConfig, int maximumStreamDataConfig) {
        this();
        this.streamIdConfig = streamIdConfig;
        this.maximumStreamDataConfig = maximumStreamDataConfig;
    }

    @Override
    public StreamDataBlockedFrameHandler getHandler(Context context) {
        return new StreamDataBlockedFrameHandler(context.getQuicContext());
    }

    @Override
    public StreamDataBlockedFrameSerializer getSerializer(Context context) {
        return new StreamDataBlockedFrameSerializer(this);
    }

    @Override
    public StreamDataBlockedFramePreparator getPreparator(Context context) {
        return new StreamDataBlockedFramePreparator(context.getChooser(), this);
    }

    @Override
    public StreamDataBlockedFrameParser getParser(Context context, InputStream stream) {
        return new StreamDataBlockedFrameParser(stream);
    }

    public ModifiableInteger getStreamId() {
        return this.streamId;
    }

    public void setStreamId(ModifiableInteger streamId) {
        this.streamId = streamId;
    }

    public void setStreamId(int streamId) {
        this.streamId = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.streamId, (Integer)streamId);
    }

    public ModifiableInteger getMaximumStreamData() {
        return this.maximumStreamData;
    }

    public void setMaximumStreamData(ModifiableInteger maximumStreamData) {
        this.maximumStreamData = maximumStreamData;
    }

    public void setMaximumStreamData(int maximumStreamData) {
        this.maximumStreamData = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.maximumStreamData, (Integer)maximumStreamData);
    }

    public int getStreamIdConfig() {
        return this.streamIdConfig;
    }

    public void setStreamIdConfig(int streamIdConfig) {
        this.streamIdConfig = streamIdConfig;
    }

    public int getMaximumStreamDataConfig() {
        return this.maximumStreamDataConfig;
    }

    public void setMaximumStreamDataConfig(int maximumStreamDataConfig) {
        this.maximumStreamDataConfig = maximumStreamDataConfig;
    }
}

