/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.quic.frame;

import de.rub.nds.modifiablevariable.ModifiableVariableFactory;
import de.rub.nds.modifiablevariable.ModifiableVariableHolder;
import de.rub.nds.modifiablevariable.ModifiableVariableProperty;
import de.rub.nds.modifiablevariable.singlebyte.ModifiableByte;
import de.rub.nds.tlsattacker.core.layer.data.DataContainer;
import de.rub.nds.tlsattacker.core.quic.constants.QuicFrameType;
import de.rub.nds.tlsattacker.core.quic.handler.frame.QuicFrameHandler;
import de.rub.nds.tlsattacker.core.quic.parser.frame.QuicFrameParser;
import de.rub.nds.tlsattacker.core.quic.preparator.frame.QuicFramePreparator;
import de.rub.nds.tlsattacker.core.quic.serializer.frame.QuicFrameSerializer;
import de.rub.nds.tlsattacker.core.state.Context;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.InputStream;

@XmlRootElement
public abstract class QuicFrame
extends ModifiableVariableHolder
implements DataContainer {
    protected boolean ackEliciting = true;
    @ModifiableVariableProperty
    private ModifiableByte frameType;

    public QuicFrame() {
    }

    public QuicFrame(QuicFrameType quicFrameType) {
        this.setFrameType(quicFrameType.getValue());
    }

    public void setFrameType(QuicFrameType frameType) {
        this.frameType = ModifiableVariableFactory.safelySetValue((ModifiableByte)this.frameType, (Byte)frameType.getValue());
    }

    public void setFrameType(ModifiableByte frameType) {
        this.frameType = frameType;
    }

    public void setFrameType(byte frameType) {
        this.frameType = ModifiableVariableFactory.safelySetValue((ModifiableByte)this.frameType, (Byte)frameType);
    }

    public ModifiableByte getFrameType() {
        return this.frameType;
    }

    public boolean isAckEliciting() {
        return this.ackEliciting;
    }

    @Override
    public String toCompactString() {
        return QuicFrameType.getFrameType((Byte)this.frameType.getValue()).getName();
    }

    public abstract QuicFrameHandler getHandler(Context var1);

    public abstract QuicFrameSerializer getSerializer(Context var1);

    public abstract QuicFramePreparator getPreparator(Context var1);

    public abstract QuicFrameParser getParser(Context var1, InputStream var2);
}

