/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.quic.frame;

import de.rub.nds.modifiablevariable.ModifiableVariableFactory;
import de.rub.nds.modifiablevariable.ModifiableVariableProperty;
import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.modifiablevariable.integer.ModifiableInteger;
import de.rub.nds.tlsattacker.core.quic.constants.QuicFrameType;
import de.rub.nds.tlsattacker.core.quic.frame.QuicFrame;
import de.rub.nds.tlsattacker.core.quic.handler.frame.DatagramFrameHandler;
import de.rub.nds.tlsattacker.core.quic.parser.frame.DatagramFrameParser;
import de.rub.nds.tlsattacker.core.quic.preparator.frame.DatagramFramePreparator;
import de.rub.nds.tlsattacker.core.quic.serializer.frame.DatagramFrameSerializer;
import de.rub.nds.tlsattacker.core.state.Context;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.InputStream;

@XmlRootElement
public class DatagramFrame
extends QuicFrame {
    @ModifiableVariableProperty
    protected ModifiableInteger length;
    @ModifiableVariableProperty
    protected ModifiableByteArray data;
    private int lengthConfig;
    private byte[] dataConfig;

    private DatagramFrame() {
    }

    public DatagramFrame(boolean isLengthField) {
        if (isLengthField) {
            this.setFrameType(QuicFrameType.DATAGRAM_FRAME_LEN);
        } else {
            this.setFrameType(QuicFrameType.DATAGRAM_FRAME);
        }
        this.ackEliciting = false;
    }

    public DatagramFrame(boolean isBidirectional, int length, byte[] dataConfig) {
        this(isBidirectional);
        this.lengthConfig = dataConfig.length;
        this.dataConfig = dataConfig;
    }

    @Override
    public DatagramFrameHandler getHandler(Context context) {
        return new DatagramFrameHandler(context.getQuicContext());
    }

    @Override
    public DatagramFrameSerializer getSerializer(Context context) {
        return new DatagramFrameSerializer(this);
    }

    @Override
    public DatagramFramePreparator getPreparator(Context context) {
        return new DatagramFramePreparator(context.getChooser(), this);
    }

    @Override
    public DatagramFrameParser getParser(Context context, InputStream stream) {
        return new DatagramFrameParser(stream);
    }

    public ModifiableInteger getLength() {
        return this.length;
    }

    public void setLength(ModifiableInteger length) {
        this.length = length;
    }

    public void setLength(int length) {
        this.length = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.length, (Integer)length);
    }

    public ModifiableByteArray getData() {
        return this.data;
    }

    public void setData(ModifiableByteArray data) {
        this.data = data;
    }

    public void setData(byte[] data) {
        this.data = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.data, (byte[])data);
    }

    public int getLengthConfig() {
        return this.lengthConfig;
    }

    public void setLengthConfig(int lengthConfig) {
        this.lengthConfig = lengthConfig;
    }

    public byte[] getDataConfig() {
        return this.dataConfig;
    }

    public void setDataConfig(byte[] dataConfig) {
        this.dataConfig = dataConfig;
    }
}

