/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.quic.constants;

import java.util.HashMap;
import java.util.Map;

public enum QuicFrameType {
    UNKNOWN(-1),
    PADDING_FRAME(0),
    PING_FRAME(1),
    ACK_FRAME(2),
    ACK_FRAME_WITH_ECN(3),
    RESET_STREAM_FRAME(4),
    STOP_SENDING_FRAME(5),
    CRYPTO_FRAME(6),
    NEW_TOKEN_FRAME(7),
    STREAM_FRAME(8),
    STREAM_FRAME_FIN(9),
    STREAM_FRAME_LEN(10),
    STREAM_FRAME_LEN_FIN(11),
    STREAM_FRAME_OFF(12),
    STREAM_FRAME_OFF_FIN(13),
    STREAM_FRAME_OFF_LEN(14),
    STREAM_FRAME_OFF_LEN_FIN(15),
    MAX_DATA_FRAME(16),
    MAX_STREAM_DATA_FRAME(17),
    MAX_STREAMS_BIDI_FRAME(18),
    MAX_STREAMS_UNI_FRAME(19),
    DATA_BLOCKED_FRAME(20),
    STREAM_DATA_BLOCKED_FRAME(21),
    STREAMS_BLOCKED_BIDI_FRAME(22),
    STREAMS_BLOCKED_UNI_FRAME(23),
    NEW_CONNECTION_ID_FRAME(24),
    RETIRE_CONNECTION_ID(25),
    PATH_CHALLENGE_FRAME(26),
    PATH_RESPONSE_FRAME(27),
    CONNECTION_CLOSE_QUIC_FRAME(28),
    CONNECTION_CLOSE_APPLICATION_FRAME(29),
    HANDSHAKE_DONE_FRAME(30),
    DATAGRAM_FRAME(48),
    DATAGRAM_FRAME_LEN(49);

    private int value;
    private static final Map<Byte, QuicFrameType> MAP;

    private QuicFrameType(byte value) {
        this.value = value;
    }

    private QuicFrameType() {
        this.value = -1;
    }

    public static QuicFrameType getFrameType(byte value) {
        QuicFrameType type = MAP.get(value);
        if (type == null) {
            type = UNKNOWN;
        }
        return type;
    }

    public byte getValue() {
        return (byte)this.value;
    }

    public String getName() {
        return this.name();
    }

    static {
        MAP = new HashMap<Byte, QuicFrameType>();
        for (QuicFrameType type : QuicFrameType.values()) {
            if (type == UNKNOWN) continue;
            MAP.put((byte)type.value, type);
        }
    }
}

