/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.serializer.extension;

import de.rub.nds.tlsattacker.core.protocol.message.extension.SignatureAlgorithmsCertExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.serializer.extension.ExtensionSerializer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SignatureAlgorithmsCertExtensionSerializer
extends ExtensionSerializer<SignatureAlgorithmsCertExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final SignatureAlgorithmsCertExtensionMessage msg;

    public SignatureAlgorithmsCertExtensionSerializer(SignatureAlgorithmsCertExtensionMessage message) {
        super(message);
        this.msg = message;
    }

    @Override
    public byte[] serializeExtensionContent() {
        LOGGER.debug("Serializing SignatureAlgorithmsCertExtensionMessage");
        this.writeSignatureAndHashAlgorithmsLength(this.msg);
        this.writeSignatureAndHashAlgorithms(this.msg);
        return this.getAlreadySerialized();
    }

    private void writeSignatureAndHashAlgorithmsLength(SignatureAlgorithmsCertExtensionMessage msg) {
        this.appendInt((Integer)msg.getSignatureAndHashAlgorithmsLength().getValue(), 2);
        LOGGER.debug("SignatureAndHashAlgorithmsLength: " + String.valueOf(msg.getSignatureAndHashAlgorithmsLength().getValue()));
    }

    private void writeSignatureAndHashAlgorithms(SignatureAlgorithmsCertExtensionMessage msg) {
        this.appendBytes((byte[])msg.getSignatureAndHashAlgorithms().getValue());
        LOGGER.debug("SignatureAndHashAlgorithms: {}", msg.getSignatureAndHashAlgorithms().getValue());
    }
}

