/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.serializer.extension;

import de.rub.nds.tlsattacker.core.protocol.message.extension.PreSharedKeyExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.serializer.extension.ExtensionSerializer;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PreSharedKeyExtensionSerializer
extends ExtensionSerializer<PreSharedKeyExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final PreSharedKeyExtensionMessage msg;

    public PreSharedKeyExtensionSerializer(PreSharedKeyExtensionMessage message, ConnectionEndType connectionType) {
        super(message);
        this.msg = message;
    }

    @Override
    public byte[] serializeExtensionContent() {
        LOGGER.debug("Serializing PreSharedKeyExtensionMessage");
        if (this.msg.getSelectedIdentity() == null || this.msg.getSelectedIdentity().getValue() == null) {
            this.appendInt((Integer)this.msg.getIdentityListLength().getValue(), 2);
            LOGGER.debug("PreSharedKeyIdentityListLength: " + String.valueOf(this.msg.getIdentityListLength().getValue()));
            this.writeIdentities();
            this.appendInt((Integer)this.msg.getBinderListLength().getValue(), 2);
            LOGGER.debug("PreSharedKeyBinderListLength: {}", this.msg.getBinderListLength().getValue());
            this.writeBinders();
        } else {
            this.writeSelectedIdentity();
        }
        return this.getAlreadySerialized();
    }

    public void writeIdentities() {
        this.appendBytes((byte[])this.msg.getIdentityListBytes().getValue());
    }

    public void writeBinders() {
        this.appendBytes((byte[])this.msg.getBinderListBytes().getValue());
    }

    public void writeSelectedIdentity() {
        this.appendInt((Integer)this.msg.getSelectedIdentity().getValue(), 2);
    }
}

