/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.serializer.extension;

import de.rub.nds.tlsattacker.core.protocol.message.extension.PWDClearExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.serializer.extension.ExtensionSerializer;
import java.nio.charset.StandardCharsets;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PWDClearExtensionSerializer
extends ExtensionSerializer<PWDClearExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final PWDClearExtensionMessage msg;

    public PWDClearExtensionSerializer(PWDClearExtensionMessage message) {
        super(message);
        this.msg = message;
    }

    @Override
    public byte[] serializeExtensionContent() {
        LOGGER.debug("Serializing PWDClearExtensionMessage");
        this.writeUsernameLength(this.msg);
        this.writeUsername(this.msg);
        return this.getAlreadySerialized();
    }

    private void writeUsernameLength(PWDClearExtensionMessage msg) {
        this.appendInt((Integer)msg.getUsernameLength().getValue(), 1);
        LOGGER.debug("UsernameLength: {}", msg.getUsernameLength().getValue());
    }

    private void writeUsername(PWDClearExtensionMessage msg) {
        this.appendBytes(((String)msg.getUsername().getValue()).getBytes(StandardCharsets.ISO_8859_1));
        LOGGER.debug("Username: {}", msg.getUsername().getValue());
    }
}

