/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.serializer;

import de.rub.nds.modifiablevariable.util.DataConverter;
import de.rub.nds.tlsattacker.core.protocol.message.PskDhClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.serializer.DHClientKeyExchangeSerializer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;

public class PskDhClientKeyExchangeSerializer
extends DHClientKeyExchangeSerializer<PskDhClientKeyExchangeMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final PskDhClientKeyExchangeMessage msg;

    public PskDhClientKeyExchangeSerializer(PskDhClientKeyExchangeMessage message) {
        super(message);
        this.msg = message;
    }

    @Override
    public byte[] serializeHandshakeMessageContent() {
        LOGGER.debug("Serializing PSKDHClientKeyExchangeMessage");
        this.writePSKIdentityLength(this.msg);
        this.writePSKIdentity(this.msg);
        super.serializeDhParams();
        return this.getAlreadySerialized();
    }

    private void writePSKIdentityLength(PskDhClientKeyExchangeMessage msg) {
        this.appendInt((Integer)msg.getIdentityLength().getValue(), 2);
        LOGGER.debug("SerializedPSKIdentityLength: {}", new Supplier[]{() -> DataConverter.bytesToInt((byte[])((byte[])msg.getIdentity().getValue()))});
    }

    private void writePSKIdentity(PskDhClientKeyExchangeMessage msg) {
        this.appendBytes((byte[])msg.getIdentity().getValue());
        LOGGER.debug("SerializedPSKIdentity: {}", msg.getIdentity().getValue());
    }
}

