/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.preparator.extension;

import de.rub.nds.protocol.util.SilentByteArrayOutputStream;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ServerNameIndicationExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.sni.ServerNamePair;
import de.rub.nds.tlsattacker.core.protocol.preparator.extension.ExtensionPreparator;
import de.rub.nds.tlsattacker.core.protocol.preparator.extension.ServerNamePairPreparator;
import de.rub.nds.tlsattacker.core.protocol.serializer.extension.ServerNamePairSerializer;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.LinkedList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerNameIndicationExtensionPreparator
extends ExtensionPreparator<ServerNameIndicationExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ServerNameIndicationExtensionMessage msg;
    private SilentByteArrayOutputStream stream;

    public ServerNameIndicationExtensionPreparator(Chooser chooser, ServerNameIndicationExtensionMessage message) {
        super(chooser, message);
        this.msg = message;
    }

    @Override
    public void prepareExtensionContent() {
        LOGGER.debug("Preparing ServerNameIndicationExtensionMessage");
        this.stream = new SilentByteArrayOutputStream();
        if (this.chooser.getConnectionEndType() == ConnectionEndType.CLIENT) {
            this.prepareEntryList();
            this.prepareServerNameListBytes(this.msg);
            this.prepareServerNameListLength(this.msg);
        } else {
            this.prepareEmptyExtension();
        }
    }

    public void prepareEntryList() {
        if (this.chooser.getConfig().getDefaultSniHostnames() == null) {
            if (this.chooser.getConnection().getHostname() == null) {
                this.prepareEmptyEntry();
            } else {
                this.prepareFromConnection();
            }
        } else {
            this.msg.setServerNameList(this.chooser.getConfig().getDefaultSniHostnames());
        }
        for (ServerNamePair pair : this.msg.getServerNameList()) {
            this.prepareEntry(this.chooser, pair);
        }
    }

    public void prepareEmptyExtension() {
        LOGGER.debug("Preparing SNI extension with empty content.");
        this.msg.setServerNameList(new LinkedList<ServerNamePair>());
        this.msg.setServerNameListBytes(new byte[0]);
    }

    public void prepareEmptyEntry() {
        LOGGER.warn("Using emtpy list for SNI extension since no entries have been specified");
        byte[] emptyName = new byte[]{};
        ServerNamePair emptyPair = new ServerNamePair(this.chooser.getConfig().getSniType().getValue(), emptyName);
        this.msg.setServerNameList(new LinkedList<ServerNamePair>(Arrays.asList(emptyPair)));
        this.prepareEntry(this.chooser, emptyPair);
    }

    private void prepareFromConnection() {
        byte[] serverName = this.chooser.getConnection().getHostname().getBytes(Charset.forName("ASCII"));
        ServerNamePair namePair = new ServerNamePair(this.chooser.getConfig().getSniType().getValue(), serverName);
        this.msg.setServerNameList(new LinkedList<ServerNamePair>(Arrays.asList(namePair)));
        this.prepareEntry(this.chooser, namePair);
    }

    private void prepareEntry(Chooser chooser, ServerNamePair namePair) {
        ServerNamePairPreparator namePairPreparator = new ServerNamePairPreparator(chooser, namePair);
        namePairPreparator.prepare();
        ServerNamePairSerializer serializer = new ServerNamePairSerializer(namePair);
        this.stream.write(serializer.serialize());
    }

    private void prepareServerNameListBytes(ServerNameIndicationExtensionMessage msg) {
        msg.setServerNameListBytes(this.stream.toByteArray());
        LOGGER.debug("ServerNameListBytes: {}", msg.getServerNameListBytes().getValue());
    }

    private void prepareServerNameListLength(ServerNameIndicationExtensionMessage msg) {
        msg.setServerNameListLength(((byte[])msg.getServerNameListBytes().getValue()).length);
        LOGGER.debug("ServerNameListLength: {}", msg.getServerNameListLength().getValue());
    }
}

