/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.preparator.extension;

import de.rub.nds.tlsattacker.core.layer.data.Preparator;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.serializer.extension.ExtensionSerializer;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class ExtensionPreparator<T extends ExtensionMessage>
extends Preparator<T> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final T msg;
    private byte[] content;
    private final ExtensionSerializer<T> serializer;

    public ExtensionPreparator(Chooser chooser, T message, ExtensionSerializer<T> serializer) {
        super(chooser, message);
        this.msg = message;
        this.serializer = serializer;
    }

    public ExtensionPreparator(Chooser chooser, T message) {
        super(chooser, message);
        this.msg = message;
        this.serializer = ((ExtensionMessage)this.msg).getSerializer(chooser.getContext());
    }

    @Override
    public final void prepare() {
        this.prepareExtensionType((ExtensionMessage)this.msg);
        this.prepareExtensionContent();
        this.content = this.serializer.serializeExtensionContent();
        this.prepareExtensionContentBytes((ExtensionMessage)this.msg);
        this.prepareExtensionLength((ExtensionMessage)this.msg);
        this.prepareExtensionBytes((ExtensionMessage)this.msg);
    }

    @Override
    public final void afterPrepare() {
        this.prepareExtensionType((ExtensionMessage)this.msg);
        this.afterPrepareExtensionContent();
        this.content = this.serializer.serializeExtensionContent();
        this.prepareExtensionContentBytes((ExtensionMessage)this.msg);
        this.prepareExtensionLength((ExtensionMessage)this.msg);
        this.prepareExtensionBytes((ExtensionMessage)this.msg);
    }

    public abstract void prepareExtensionContent();

    public void afterPrepareExtensionContent() {
    }

    private void prepareExtensionType(ExtensionMessage msg) {
        msg.setExtensionType(msg.getExtensionTypeConstant().getValue());
        LOGGER.debug("ExtensionType: {}", msg.getExtensionType().getValue());
    }

    private void prepareExtensionLength(ExtensionMessage msg) {
        msg.setExtensionLength(((byte[])msg.getExtensionContent().getValue()).length);
        LOGGER.debug("ExtensionLength: {}", msg.getExtensionLength().getValue());
    }

    private void prepareExtensionBytes(ExtensionMessage msg) {
        msg.setExtensionBytes(this.serializer.serialize());
        LOGGER.debug("ExtensionBytes: {}", msg.getExtensionBytes().getValue());
    }

    private void prepareExtensionContentBytes(ExtensionMessage msg) {
        msg.setExtensionContent(this.content);
        LOGGER.debug("ExtensionContent: {}", msg.getExtensionContent().getValue());
    }
}

