/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.preparator.extension;

import de.rub.nds.protocol.util.SilentByteArrayOutputStream;
import de.rub.nds.tlsattacker.core.layer.data.Preparator;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ClientEsniInner;
import de.rub.nds.tlsattacker.core.protocol.message.extension.sni.ServerNamePair;
import de.rub.nds.tlsattacker.core.protocol.preparator.extension.ServerNamePairPreparator;
import de.rub.nds.tlsattacker.core.protocol.serializer.extension.ServerNamePairSerializer;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClientEsniInnerPreparator
extends Preparator<ClientEsniInner> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ClientEsniInner msg;
    private SilentByteArrayOutputStream serverNamePairListStream;

    public ClientEsniInnerPreparator(Chooser chooser, ClientEsniInner message) {
        super(chooser, message);
        this.msg = message;
    }

    @Override
    public void prepare() {
        LOGGER.debug("Preparing ClientEsniInner");
        this.prepareNonce(this.msg);
        this.prepareServerPariNameList(this.msg);
        this.prepareServerNameListBytes(this.msg);
        this.prepareServerNameListLength(this.msg);
        this.preparePadding(this.msg);
    }

    private void prepareNonce(ClientEsniInner msg) {
        byte[] nonce = this.chooser.getEsniClientNonce();
        msg.setClientNonce(nonce);
        LOGGER.debug("Nonce: {}", msg.getClientNonce().getValue());
    }

    private void prepareServerPariNameList(ClientEsniInner msg) {
        this.serverNamePairListStream = new SilentByteArrayOutputStream();
        for (ServerNamePair pair : msg.getServerNameList()) {
            ServerNamePairPreparator preparator = new ServerNamePairPreparator(this.chooser, pair);
            preparator.prepare();
            ServerNamePairSerializer serializer = new ServerNamePairSerializer(pair);
            this.serverNamePairListStream.write(serializer.serialize());
        }
    }

    private void prepareServerNameListBytes(ClientEsniInner msg) {
        msg.setServerNameListBytes(this.serverNamePairListStream.toByteArray());
        LOGGER.debug("ServerNameListBytes: {}", msg.getServerNameListBytes().getValue());
    }

    private void prepareServerNameListLength(ClientEsniInner msg) {
        msg.setServerNameListLength(((byte[])msg.getServerNameListBytes().getValue()).length);
        LOGGER.debug("ServerNameListLength: {}", msg.getServerNameListLength().getValue());
    }

    private void preparePadding(ClientEsniInner msg) {
        int paddedLength = this.chooser.getEsniPaddedLength();
        int paddingLength = paddedLength - ((byte[])msg.getServerNameListBytes().getValue()).length - 2;
        if (paddingLength > 65536) {
            LOGGER.warn("ESNI Inner PaddingLength is greater than 65536. Limiting it to 65536");
            paddingLength = 65536;
        }
        byte[] padding = paddingLength > 0 ? new byte[paddingLength] : new byte[]{};
        msg.setPadding(padding);
        LOGGER.debug("PaddedLength: {}", (Object)paddedLength);
        LOGGER.debug("Padding: {}", msg.getPadding().getValue());
    }
}

