/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.preparator;

import de.rub.nds.modifiablevariable.util.DataConverter;
import de.rub.nds.protocol.util.SilentByteArrayOutputStream;
import de.rub.nds.tlsattacker.core.protocol.message.PskRsaClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.preparator.RSAClientKeyExchangePreparator;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PskRsaClientKeyExchangePreparator
extends RSAClientKeyExchangePreparator<PskRsaClientKeyExchangeMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final PskRsaClientKeyExchangeMessage msg;
    private SilentByteArrayOutputStream outputStream;

    public PskRsaClientKeyExchangePreparator(Chooser chooser, PskRsaClientKeyExchangeMessage message) {
        super(chooser, message);
        this.msg = message;
    }

    @Override
    public void prepareHandshakeMessageContents() {
        this.msg.setIdentity(this.chooser.getPSKIdentity());
        this.msg.setIdentityLength(((byte[])this.msg.getIdentity().getValue()).length);
        super.prepareHandshakeMessageContents();
    }

    @Override
    protected byte[] manipulatePremasterSecret(byte[] premasterSecret) {
        this.outputStream = new SilentByteArrayOutputStream();
        this.outputStream.write(DataConverter.intToBytes((int)48, (int)2));
        this.outputStream.write(premasterSecret);
        this.outputStream.write(DataConverter.intToBytes((int)this.chooser.getConfig().getDefaultPSKKey().length, (int)2));
        this.outputStream.write(this.chooser.getConfig().getDefaultPSKKey());
        byte[] tempPremasterSecret = this.outputStream.toByteArray();
        return tempPremasterSecret;
    }
}

