/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.preparator;

import de.rub.nds.modifiablevariable.util.DataConverter;
import de.rub.nds.modifiablevariable.util.RandomHelper;
import de.rub.nds.protocol.exception.CryptoException;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.constants.CipherAlgorithm;
import de.rub.nds.tlsattacker.core.protocol.message.NewSessionTicketMessage;
import de.rub.nds.tlsattacker.core.protocol.preparator.HandshakeMessagePreparator;
import de.rub.nds.tlsattacker.core.state.SessionTicket;
import de.rub.nds.tlsattacker.core.state.StatePlaintext;
import de.rub.nds.tlsattacker.core.state.serializer.SessionTicketSerializer;
import de.rub.nds.tlsattacker.core.state.serializer.StatePlaintextSerializer;
import de.rub.nds.tlsattacker.core.util.StaticTicketCrypto;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NewSessionTicketPreparator
extends HandshakeMessagePreparator<NewSessionTicketMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final NewSessionTicketMessage msg;

    public NewSessionTicketPreparator(Chooser chooser, NewSessionTicketMessage message) {
        super(chooser, message);
        this.msg = message;
    }

    private long generateTicketLifetimeHint() {
        long ticketLifeTimeHint = this.chooser.getConfig().getSessionTicketLifetimeHint();
        return ticketLifeTimeHint;
    }

    private void prepareTicketLifetimeHint(NewSessionTicketMessage msg) {
        msg.setTicketLifetimeHint(this.generateTicketLifetimeHint());
        LOGGER.debug("TicketLifetimeHint: {}", msg.getTicketLifetimeHint().getValue());
    }

    private void prepareTicket(NewSessionTicketMessage msg) {
        byte[] hmac;
        byte[] encryptedState;
        Config config = this.chooser.getConfig();
        SessionTicket newTicket = msg.getTicket();
        newTicket.setKeyName(config.getSessionTicketKeyName());
        CipherAlgorithm cipherAlgorithm = config.getSessionTicketCipherAlgorithm();
        byte[] encryptionKey = config.getSessionTicketEncryptionKey();
        byte[] iv = new byte[cipherAlgorithm.getBlocksize()];
        RandomHelper.getRandom().nextBytes(iv);
        newTicket.setIV(iv);
        StatePlaintext plainState = new StatePlaintext();
        plainState.generateStatePlaintext(this.chooser);
        StatePlaintextSerializer plaintextSerializer = new StatePlaintextSerializer(plainState);
        byte[] plainStateSerialized = plaintextSerializer.serialize();
        try {
            encryptedState = StaticTicketCrypto.encrypt(cipherAlgorithm, plainStateSerialized, encryptionKey, (byte[])newTicket.getIV().getValue());
        }
        catch (CryptoException e) {
            LOGGER.warn("Could not encrypt SessionState. Using empty byte[]");
            LOGGER.debug((Object)e);
            encryptedState = new byte[]{};
        }
        newTicket.setEncryptedState(encryptedState);
        byte[] keyHMAC = config.getSessionTicketKeyHMAC();
        byte[] macInput = DataConverter.concatenate((byte[][])new byte[][]{config.getSessionTicketKeyName(), iv, DataConverter.intToBytes((int)encryptedState.length, (int)2), encryptedState});
        try {
            hmac = StaticTicketCrypto.generateHMAC(config.getSessionTicketMacAlgorithm(), macInput, keyHMAC);
        }
        catch (CryptoException ex) {
            LOGGER.warn("Could generate HMAC. Using empty byte[]");
            LOGGER.debug((Object)ex);
            hmac = new byte[]{};
        }
        newTicket.setMAC(hmac);
        newTicket.setEncryptedStateLength(encryptedState.length);
        SessionTicketSerializer sessionTicketSerializer = new SessionTicketSerializer(newTicket);
        byte[] sessionTicketSerialized = sessionTicketSerializer.serialize();
        msg.getTicket().setIdentityLength(sessionTicketSerialized.length);
        msg.getTicket().setIdentity(sessionTicketSerialized);
    }

    @Override
    protected void prepareHandshakeMessageContents() {
        LOGGER.debug("Preparing NewSessionTicketMessage");
        this.prepareTicketLifetimeHint(this.msg);
        if (this.chooser.getSelectedProtocolVersion().is13()) {
            this.prepareTicketTls13(this.msg);
        } else {
            this.prepareTicket(this.msg);
        }
    }

    private void prepareTicketTls13(NewSessionTicketMessage msg) {
        this.prepareTicketAgeAdd(msg);
        this.prepareNonce(msg);
        this.prepareIdentity(msg);
        this.prepareExtensions();
        this.prepareExtensionLength();
    }

    private void prepareTicketAgeAdd(NewSessionTicketMessage msg) {
        msg.getTicket().setTicketAgeAdd(this.chooser.getConfig().getDefaultSessionTicketAgeAdd());
    }

    private void prepareIdentity(NewSessionTicketMessage msg) {
        msg.getTicket().setIdentity(this.chooser.getConfig().getDefaultSessionTicketIdentity());
        msg.getTicket().setIdentityLength(((byte[])msg.getTicket().getIdentity().getValue()).length);
    }

    private void prepareNonce(NewSessionTicketMessage msg) {
        msg.getTicket().setTicketNonce(this.chooser.getConfig().getDefaultSessionTicketNonce());
        msg.getTicket().setTicketNonceLength(((byte[])msg.getTicket().getTicketNonce().getValue()).length);
    }

    @Override
    public void prepareAfterParse() {
        if (this.chooser.getSelectedProtocolVersion().is13()) {
            this.msg.setIncludeInDigest(false);
        }
    }
}

