/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.preparator;

import de.rub.nds.tlsattacker.core.protocol.message.HelloVerifyRequestMessage;
import de.rub.nds.tlsattacker.core.protocol.preparator.HandshakeMessagePreparator;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HelloVerifyRequestPreparator
extends HandshakeMessagePreparator<HelloVerifyRequestMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final HelloVerifyRequestMessage msg;

    public HelloVerifyRequestPreparator(Chooser chooser, HelloVerifyRequestMessage message) {
        super(chooser, message);
        this.msg = message;
    }

    @Override
    public void prepareHandshakeMessageContents() {
        LOGGER.debug("Preparing HelloVerifyRequestMessage");
        this.prepareCookie(this.msg);
        this.prepareCookieLength(this.msg);
        this.prepareProtocolVersion(this.msg);
    }

    private byte[] generateCookie() {
        int cookieLength = this.chooser.getConfig().getDtlsDefaultCookieLength();
        if (cookieLength > 256) {
            LOGGER.warn("Cookie length is greater than 256. Returning it mod 256");
            cookieLength %= 256;
        }
        byte[] cookie = new byte[cookieLength];
        this.chooser.getContext().getTlsContext().getRandom().nextBytes(cookie);
        return cookie;
    }

    private void prepareCookie(HelloVerifyRequestMessage msg) {
        msg.setCookie(this.generateCookie());
        LOGGER.debug("Cookie: {}", msg.getCookie().getValue());
    }

    private void prepareCookieLength(HelloVerifyRequestMessage msg) {
        msg.setCookieLength((byte)((byte[])msg.getCookie().getValue()).length);
        LOGGER.debug("CookieLength: {}", msg.getCookieLength().getValue());
    }

    private void prepareProtocolVersion(HelloVerifyRequestMessage msg) {
        msg.setProtocolVersion(this.chooser.getConfig().getHighestProtocolVersion().getValue());
        LOGGER.debug("ProtocolVersion: {}", msg.getProtocolVersion().getValue());
    }
}

