/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser.extension;

import de.rub.nds.tlsattacker.core.constants.TrustedCaIndicationIdentifierType;
import de.rub.nds.tlsattacker.core.layer.data.Parser;
import de.rub.nds.tlsattacker.core.protocol.message.extension.trustedauthority.TrustedAuthority;
import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TrustedAuthorityParser
extends Parser<TrustedAuthority> {
    private static final Logger LOGGER = LogManager.getLogger();

    public TrustedAuthorityParser(InputStream stream) {
        super(stream);
    }

    @Override
    public void parse(TrustedAuthority authority) {
        authority.setIdentifierType(this.parseByteField(1));
        switch (TrustedCaIndicationIdentifierType.getIdentifierByByte((Byte)authority.getIdentifierType().getValue())) {
            case PRE_AGREED: {
                break;
            }
            case CERT_SHA1_HASH: 
            case KEY_SHA1_HASH: {
                authority.setSha1Hash(this.parseByteArrayField(20));
                break;
            }
            case X509_NAME: {
                authority.setDistinguishedNameLength(this.parseIntField(2));
                authority.setDistinguishedName(this.parseByteArrayField((Integer)authority.getDistinguishedNameLength().getValue()));
                break;
            }
            default: {
                LOGGER.warn("Couldn't set the trusted authority to reasonable values");
            }
        }
    }
}

