/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser.extension;

import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.protocol.message.extension.SupportedVersionsExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.ExtensionParser;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SupportedVersionsExtensionParser
extends ExtensionParser<SupportedVersionsExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public SupportedVersionsExtensionParser(InputStream stream, TlsContext tlsContext) {
        super(stream, tlsContext);
    }

    @Override
    public void parse(SupportedVersionsExtensionMessage msg) {
        LOGGER.debug("Parsing SupportedVersionsExtensionMessage");
        if (this.getTlsContext().getTalkingConnectionEndType() == ConnectionEndType.SERVER) {
            msg.setSupportedVersions(this.parseByteArrayField(2));
            LOGGER.debug("Supported version: {}", msg.getSupportedVersions().getValue());
        } else {
            this.parseSupportedVersionLength(msg);
            this.parseSupportedVersion(msg);
        }
    }

    private void parseSupportedVersionLength(SupportedVersionsExtensionMessage msg) {
        msg.setSupportedVersionsLength(this.parseIntField(1));
        LOGGER.debug("SupportedVersionsLength: {}", msg.getSupportedVersionsLength().getValue());
    }

    private void parseSupportedVersion(SupportedVersionsExtensionMessage msg) {
        msg.setSupportedVersions(this.parseByteArrayField((Integer)msg.getSupportedVersionsLength().getValue()));
        LOGGER.debug("SupportedVersions: {}", msg.getSupportedVersions().getValue());
    }
}

